package com.xforceplus.janus.generator.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.xforceplus.janus.commons.util.PageUtils;
import com.xforceplus.janus.generator.domain.GenModel;
import com.xforceplus.janus.generator.dto.ModelPropertyDto;
import com.xforceplus.janus.generator.param.GenModelParam;

import java.util.List;
import java.util.Map;

/**
 * 业务服务层
 *
 * @author 许传厚
 */
public interface IGenModelService extends IService<GenModel> {
    /**
     * 获取定义
     * @param projectId 项目ID
     * @param cascade 是否级联加载属性
     * @return:
     * @Author: xucuanhou
     * @Date: 2021/10/20
     */
    GenModel getRichModel(String projectId, String className,boolean cascade);

    /**
    * @param projectId 项目Id
     * @param excludClassName 排除项
    * @return
    * @author xucuanhou
    * @date 2021/10/21
     */
    List<GenModel> findSimpleModel(String projectId, String excludClassName);

    /**
     * 从结构定义获取mock 数据
    * @param  projectId 项目
    * @return
    * @author xucuanhou
    * @date 2021/10/21
     */
    Map<String, Object> getMockFromModeDefine(String projectId, String className);

    List<ModelPropertyDto> genPropertyFromProperty(String projectId,String property);


    PageUtils queryPager(GenModelParam param);

    /**
     * 根据ID 删除
     * @param id
     */
    boolean deleteById(String id);

    GenModel info(String id);

    boolean saveOrUpdateEntity(GenModel modelDefine);

}
