package com.xforceplus.janus.generator.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xforceplus.janus.common.constants.Constant;
import com.xforceplus.janus.common.text.Convert;
import com.xforceplus.janus.generator.domain.GenTableColumn;
import com.xforceplus.janus.generator.mapper.*;
import com.xforceplus.janus.generator.service.*;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * 业务字段 服务层实现
 *
 * @author just
 */
@Component
public class GenTableColumnServiceImpl extends ServiceImpl<GenTableColumnMapper, GenTableColumn> implements
        IGenTableColumnService {

    /**
     * 查询业务字段列表
     *
     * @param tableId 业务字段信息
     * @return 业务字段集合
     */
    @Override
    public List<GenTableColumn> selectGenTableColumnListByTableId(Long tableId) {
        return this.list(new QueryWrapper<GenTableColumn>()
                .eq("table_id", tableId)
                .eq(Constant.IS_VALID, Constant.IS_VALIDED)
                .orderByAsc("sort"));
    }

    /**
     * 删除业务字段对象
     *
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    @Override
    public int deleteGenTableColumnByIds(String ids) {
        return this.baseMapper.deleteGenTableColumnByIds(Convert.toLongArray(ids));
    }


    @Override
    public boolean deleteGenTableColumnByIds(Collection<Long> ids) {
        if (CollectionUtils.isNotEmpty(ids)) {
            List<GenTableColumn> columns = new ArrayList<>(ids.size());
            ids.forEach(id -> {
                columns.add(new GenTableColumn(id, Constant.IS_NOT_VALIDED));
            });

            return this.updateBatchById(columns);
        }
        return false;
    }

    @Override
    public boolean deleteByTableId(long id) {
        return this.update(new UpdateWrapper<GenTableColumn>()
                .eq("table_id", id).set(Constant.IS_VALID, Constant.IS_NOT_VALIDED));
    }

    @Override
    public boolean saveOrUpdateColumn(GenTableColumn column) {
        GenTableColumn existCol = queryByColName(column.getTableId(), column.getColumnName());
        if (existCol != null) {
            column.setColumnId(existCol.getColumnId());
            column.setCreatedTime(existCol.getCreatedTime());
            column.setIsValid(Constant.IS_VALIDED);
        }
        return this.saveOrUpdate(column);
    }

    @Override
    public GenTableColumn queryByColName(Long tableId, String columnName) {
        return this.getOne(new QueryWrapper<GenTableColumn>()
                .eq("table_id", tableId)
                .eq("column_name", columnName));
    }
}