/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.generator.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.commons.util.PageUtils;
import com.xforceplus.janus.generator.domain.GenModel;
import com.xforceplus.janus.generator.dto.ModelPropertyDto;
import com.xforceplus.janus.generator.mapper.GenModelMapper;
import com.xforceplus.janus.generator.param.GenModelParam;
import com.xforceplus.janus.generator.service.IGenModelService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

@Component
public class GenModelServiceImpl
extends ServiceImpl<GenModelMapper, GenModel>
implements IGenModelService {
    private static final Logger log = LoggerFactory.getLogger(GenModelServiceImpl.class);

    @Override
    @Cacheable(cacheNames={"modelByPrjId"}, key="#projectId+#className")
    public GenModel getRichModel(String projectId, String className, boolean cascade) {
        GenModel model = (GenModel)((Object)this.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"class_name", (Object)className)).eq(StringUtils.isNotBlank((CharSequence)projectId), (Object)"project_id", (Object)projectId)).eq((Object)"is_valid", (Object)1)));
        if (model == null || StringUtils.isBlank((CharSequence)model.getProperty())) {
            return model;
        }
        List properties = null;
        properties = cascade ? this.genPropertyFromProperty(projectId, model.getProperty()) : JacksonUtil.getInstance().fromJsonToList(model.getProperty(), ModelPropertyDto.class);
        model.setProperties(properties);
        return model;
    }

    @Override
    public List<GenModel> findSimpleModel(String projectId, String excludClassName) {
        List models = this.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().notIn(StringUtils.isNotBlank((CharSequence)excludClassName), (Object)"class_name", new Object[]{excludClassName})).eq(StringUtils.isNotBlank((CharSequence)projectId), (Object)"project_id", (Object)projectId)).eq((Object)"is_valid", (Object)1));
        return models;
    }

    @Override
    public Map<String, Object> getMockFromModeDefine(String projectId, String className) {
        GenModel model = this.getRichModel(projectId, className, true);
        if (model == null) {
            return null;
        }
        return this.mockData(model);
    }

    private Map<String, Object> mockData(GenModel model) {
        HashMap<String, Object> mockData = new HashMap<String, Object>();
        block15: for (ModelPropertyDto col : model.getProperties()) {
            switch (col.getType()) {
                case "Integer": 
                case "Long": 
                case "Double": 
                case "BigDecimal": {
                    mockData.put(col.getName(), StringUtils.isBlank((CharSequence)col.getDeValue()) ? Integer.valueOf(1) : col.getDeValue());
                    continue block15;
                }
                case "Boolean": {
                    mockData.put(col.getName(), StringUtils.isBlank((CharSequence)col.getDeValue()) ? false : Boolean.valueOf(col.getDeValue()));
                    continue block15;
                }
                case "Array": {
                    ArrayList<Map<String, Object>> subs = new ArrayList<Map<String, Object>>();
                    GenModel modelsub = new GenModel(col.getRefClassName(), col.getChildren());
                    Map<String, Object> mockMap = this.mockData(modelsub);
                    subs.add(mockMap);
                    mockData.put(col.getName(), subs);
                    continue block15;
                }
                case "Object": {
                    GenModel modelsubObj = new GenModel(col.getRefClassName(), col.getChildren());
                    Map<String, Object> mocksubMap = this.mockData(modelsubObj);
                    mockData.put(col.getName(), mocksubMap);
                    continue block15;
                }
            }
            mockData.put(col.getName(), StringUtils.isBlank((CharSequence)col.getDeValue()) ? "aa" : col.getDeValue());
        }
        return mockData;
    }

    @Override
    public List<ModelPropertyDto> genPropertyFromProperty(String projectId, String property) {
        List properties = JacksonUtil.getInstance().fromJsonToList(property, ModelPropertyDto.class);
        this.paddingProperty(projectId, properties);
        return properties;
    }

    public void paddingProperty(String projectId, List<ModelPropertyDto> properties) {
        if (CollectionUtils.isEmpty(properties)) {
            return;
        }
        properties.forEach(proper -> {
            if (StringUtils.isNotBlank((CharSequence)proper.getRefClassName())) {
                GenModel subModel = this.getRichModel(projectId, proper.getRefClassName(), true);
                if (subModel != null) {
                    proper.setChildren(subModel.getProperties());
                }
            } else if (CollectionUtils.isNotEmpty(proper.getChildren())) {
                this.paddingProperty(projectId, proper.getChildren());
            }
        });
    }

    @Override
    public PageUtils queryPager(GenModelParam param) {
        Page pageParam = new Page((long)param.getPage(), (long)param.getSize());
        IPage page = this.page((IPage)pageParam, (Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq(StringUtils.isNotBlank((CharSequence)param.getClassName()), (Object)"class_name", (Object)param.getClassName())).like(StringUtils.isNotBlank((CharSequence)param.getClassNameLike()), (Object)"class_name", (Object)param.getClassName())).eq(StringUtils.isNotBlank((CharSequence)param.getProjectId()), (Object)"project_id", (Object)param.getProjectId())).eq((Object)"is_valid", (Object)1));
        return new PageUtils(page);
    }

    @Override
    public boolean deleteById(String id) {
        GenModel model = new GenModel();
        model.setId(id);
        model.setIsValid(0);
        return this.updateById((Object)model);
    }

    @Override
    public GenModel info(String id) {
        GenModel model = (GenModel)((Object)this.getById((Serializable)((Object)id)));
        if (model != null && StringUtils.isNotBlank((CharSequence)model.getProperty())) {
            model.setProperties(JacksonUtil.getInstance().fromJsonToList(model.getProperty(), ModelPropertyDto.class));
            model.setProperty(null);
        }
        return model;
    }

    @Override
    public boolean saveOrUpdateEntity(GenModel modelDefine) {
        if (CollectionUtils.isNotEmpty(modelDefine.getProperties())) {
            modelDefine.getProperties().forEach(field -> field.setChildren(null));
            modelDefine.setProperty(JacksonUtil.getInstance().toJson(modelDefine.getProperties()));
        }
        return this.saveOrUpdate((Object)modelDefine);
    }
}

