/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.generator.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.generator.dto.ModelPropertyDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ModelGenTool {
    public static final String ROOT_KEY = "root";

    public static List<ModelPropertyDto> jsonToModelProperty(JsonNode jsonObject, String parentKey) {
        if (jsonObject.isArray()) {
            HashMap<String, JsonNode> root = new HashMap<String, JsonNode>();
            root.put(ROOT_KEY, jsonObject);
            String js = JacksonUtil.getInstance().toJson(root);
            jsonObject = (JsonNode)JacksonUtil.getInstance().fromJson(js, JsonNode.class);
        }
        ArrayList<ModelPropertyDto> propertyList = new ArrayList<ModelPropertyDto>();
        Iterator it = jsonObject.fields();
        while (it.hasNext()) {
            List<ModelPropertyDto> children;
            String key;
            Map.Entry entry = (Map.Entry)it.next();
            String name = (String)entry.getKey();
            JsonNode jv = (JsonNode)entry.getValue();
            String string = key = StringUtils.isBlank((String)parentKey) ? name : parentKey + "/" + name;
            if (jv.isArray()) {
                ModelPropertyDto arry = new ModelPropertyDto(name, "Array", null, key);
                if (jv.size() > 0) {
                    if (jv.get(0).isObject()) {
                        children = ModelGenTool.jsonToModelProperty(jv.get(0), arry.getKey());
                        arry.setChildren(children);
                    } else if (jv.get(0) instanceof ValueNode) {
                        arry.setDeValue(jv.get(0).asText());
                    }
                }
                propertyList.add(arry);
                continue;
            }
            if (jv.isObject()) {
                ModelPropertyDto obj = new ModelPropertyDto(name, "Object", null, key);
                children = ModelGenTool.jsonToModelProperty(jv, obj.getKey());
                obj.setChildren(children);
                propertyList.add(obj);
                continue;
            }
            String type = "String";
            if (jv.isBoolean()) {
                type = "Boolean";
            } else if (jv.isNumber()) {
                type = "Number";
            }
            ModelPropertyDto field = new ModelPropertyDto(name, type, jv.textValue(), key);
            propertyList.add(field);
        }
        return propertyList;
    }

    public static void mergeProperty(List<ModelPropertyDto> sources, List<ModelPropertyDto> cmpProperties) {
        HashMap sourcesMap = new HashMap();
        HashMap cmpMap = new HashMap();
        if (CollectionUtils.isNotEmpty(sources) && CollectionUtils.isNotEmpty(cmpProperties)) {
            sources.forEach(field -> ModelGenTool.treeToMap(field, sourcesMap, null));
            cmpProperties.forEach(field -> ModelGenTool.treeToMap(field, cmpMap, null));
            for (Map.Entry entry : sourcesMap.entrySet()) {
                if (!cmpMap.containsKey(entry.getKey())) continue;
                ModelPropertyDto exist = (ModelPropertyDto)cmpMap.get(entry.getKey());
                ((ModelPropertyDto)entry.getValue()).setType(exist.getType());
                ((ModelPropertyDto)entry.getValue()).setDescribe(exist.getDescribe());
                ((ModelPropertyDto)entry.getValue()).setRefClassName(exist.getRefClassName());
                ((ModelPropertyDto)entry.getValue()).setMustFill(exist.getMustFill());
                ((ModelPropertyDto)entry.getValue()).setLen(exist.getLen());
                ((ModelPropertyDto)entry.getValue()).setRemark(exist.getRemark());
            }
        }
    }

    protected static void treeToMap(ModelPropertyDto propertyDto, Map<String, ModelPropertyDto> maps, String treePath) {
        String key = StringUtils.isBlank((String)treePath) ? propertyDto.getName() : treePath + "/" + propertyDto.getName();
        maps.put(key, propertyDto);
        if (CollectionUtils.isNotEmpty(propertyDto.getChildren())) {
            propertyDto.getChildren().forEach(field -> ModelGenTool.treeToMap(field, maps, key));
        }
    }

    public static String converField2JsonStr(List<ModelPropertyDto> fields) {
        Map<String, Object> jsonMap = ModelGenTool.converField2Json(fields);
        if (jsonMap.containsKey(ROOT_KEY)) {
            return JacksonUtil.getInstance().toJson(jsonMap.get(ROOT_KEY));
        }
        return JacksonUtil.getInstance().toJson(jsonMap);
    }

    private static Map<String, Object> converField2Json(List<ModelPropertyDto> fields) {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        for (ModelPropertyDto field : fields) {
            switch (field.getType()) {
                case "Object": {
                    jsonMap.put(field.getName(), ModelGenTool.converField2Json(field.getChildren()));
                    break;
                }
                case "Array": {
                    ArrayList<Map<String, Object>> jsonMapList = new ArrayList<Map<String, Object>>();
                    if (CollectionUtils.isNotEmpty(field.getChildren())) {
                        jsonMapList.add(ModelGenTool.converField2Json(field.getChildren()));
                    }
                    jsonMap.put(field.getName(), jsonMapList);
                    break;
                }
                case "Number": {
                    try {
                        jsonMap.put(field.getName(), StringUtils.isNotBlank((String)field.getDeValue()) ? new BigDecimal(field.getDeValue()) : Integer.valueOf(0));
                    }
                    catch (Exception ex) {
                        jsonMap.put(field.getName(), false);
                    }
                    break;
                }
                case "Boolean": {
                    try {
                        jsonMap.put(field.getName(), StringUtils.isNotBlank((String)field.getDeValue()) ? Boolean.valueOf(field.getDeValue()) : false);
                    }
                    catch (Exception ex) {
                        jsonMap.put(field.getName(), 0);
                    }
                    break;
                }
                case "String": {
                    jsonMap.put(field.getName(), field.getDeValue());
                    break;
                }
            }
        }
        return jsonMap;
    }
}

