package com.xforceplus.janus.generator.util;



import org.apache.commons.lang3.StringUtils;

import java.io.*;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtils {

    private ZipOutputStream out;

    private String zipFile;

    private String projectCode;

    public ZipUtils(String zipFile,String projectCode) throws IOException {
        out = new ZipOutputStream(new FileOutputStream(zipFile));
        this.zipFile = zipFile;
        this.projectCode = "bridgehead-"+projectCode;
    }

    public void doCompress(String srcFile) throws IOException {
        File file = new File(this.zipFile);
        doCompress(new File(srcFile));
    }

    /**
     * 文件压缩
     * @param srcFile 目录或者单个文件
     */
    public void doCompress(File srcFile) throws IOException {
        try {
            doCompress(srcFile, out);
        } catch (Exception e) {
            throw e;
        }
    }

    public void doCompress(File file, ZipOutputStream out) throws IOException {
        doCompress(file, out, "");
    }

    public void doCompress(File inFile, ZipOutputStream out, String dir) throws IOException {
        if ( inFile.isDirectory() ) {
            File[] files = inFile.listFiles();
            if (files!=null && files.length>0) {
                for (File file : files) {
                    String name = inFile.getName();
                    if (!"".equals(dir)) {
                        name = dir + "/" + name;
                    }
                    doCompress(file, out, name);
                }
            }
        } else {
            doZip(inFile, out, dir);
        }
    }

    public void doZip(File inFile, ZipOutputStream out, String dir) throws IOException {
        String entryName = null;
        if (!"".equals(dir)) {
            entryName = dir + "/" + inFile.getName();
        } else {
            entryName = inFile.getName();
        }
        if(StringUtils.isNotEmpty(this.projectCode)&& entryName.indexOf("/")>0){
            entryName = this.projectCode+entryName.substring(entryName.indexOf("/"));
        }
        ZipEntry entry = new ZipEntry(entryName);
        out.putNextEntry(entry);

        int len;
        byte[] buffer = new byte[1024];
        FileInputStream fis = new FileInputStream(inFile);
        while ((len = fis.read(buffer)) > 0) {
            out.write(buffer, 0, len);
            out.flush();
        }
        out.closeEntry();
        fis.close();
    }

    public void close () throws IOException {
        if (null != out)
            out.close();
    }

    /**
     * 把单个文件写入到ZIP输出流
     * @param file
     */
    public void writeToZipFile(File file) {
        if(file.exists()) {
            if (file.isFile()) {
                FileInputStream fis = null;
                BufferedInputStream bis = null;
                try {
                    fis = new FileInputStream(file);
                    bis = new BufferedInputStream(fis);
                    ZipEntry entry = new ZipEntry(file.getName());
                    out.putNextEntry(entry);
                    // 向压缩文件中输出数据
                    int length;
                    byte[] buffer = new byte[4096];
                    while ((length = bis.read(buffer)) != -1) {
                        out.write(buffer, 0, length);
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                } finally {
                    // 关闭创建的流对象
                    try {
                        bis.close();
                        fis.close();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                writeToZipFile(file.listFiles());
            }
        }
    }

    public ZipOutputStream getOut() {
        return out;
    }

    /**
     * 把多个文件写入到ZIP输出流
     * @param files
     */
    public void writeToZipFile(File[] files){
        int length = files.length;
        for(int i = 0; i < length; i++) {
            writeToZipFile(files[i]);
        }
    }

    public String getZipFile() {
        return zipFile;
    }

    public static void main(String[] args) throws IOException {
//        ZipUtils utils = new ZipUtils("/Volumes/P20S/workcode/gateway-ops/target/java1.zip");
//        utils.doCompress("/Volumes/P20S/workcode/bridgehead/bridgehead-integration/");
//        utils.close();
    }
}
