/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.generator.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xforceplus.janus.commons.util.PageUtils;
import com.xforceplus.janus.generator.domain.GenTable;
import com.xforceplus.janus.generator.domain.GenTableColumn;
import com.xforceplus.janus.generator.mapper.GenTableColumnMapper;
import com.xforceplus.janus.generator.mapper.GenTableMapper;
import com.xforceplus.janus.generator.param.GenTableParam;
import com.xforceplus.janus.generator.service.IGenTableColumnService;
import com.xforceplus.janus.generator.service.IGenTableService;
import com.xforceplus.janus.generator.util.Convert;
import com.xforceplus.janus.generator.util.GenUtils;
import com.xforceplus.janus.generator.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class GenTableServiceImpl
extends ServiceImpl<GenTableMapper, GenTable>
implements IGenTableService {
    private static final Logger log = LoggerFactory.getLogger(GenTableServiceImpl.class);
    @Autowired
    private GenTableMapper genTableMapper;
    @Autowired
    private GenTableColumnMapper genTableColumnMapper;
    @Autowired
    private IGenTableColumnService columnService;

    public GenTable selectGenTableById(Long id) {
        GenTable genTable = (GenTable)this.genTableMapper.selectById(id);
        return genTable;
    }

    @Override
    public List<GenTable> selectGenTableList(GenTable genTable) {
        return this.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"IS_VALID", (Object)1)).eq(StringUtils.isNotBlank((CharSequence)genTable.getProjectId()), (Object)"project_id", (Object)genTable.getProjectId())).and(StringUtils.isNotBlank((CharSequence)genTable.getBusinessName()) && StringUtils.isNotBlank((CharSequence)genTable.getTableComment()), w -> (QueryWrapper)((QueryWrapper)((QueryWrapper)w.like(StringUtils.isNotBlank((CharSequence)genTable.getBusinessName()), (Object)"business_name", (Object)genTable.getBusinessName())).or()).like(StringUtils.isNotBlank((CharSequence)genTable.getTableComment()), (Object)"table_comment", (Object)genTable.getTableComment())));
    }

    @Override
    public List<GenTable> selectDbTableList(GenTable genTable) {
        return this.genTableMapper.selectDbTableList(genTable);
    }

    @Override
    public List<GenTable> selectDbTableListByNames(String[] tableNames) {
        return this.genTableMapper.selectDbTableListByNames(tableNames);
    }

    @Override
    @Transactional
    public void updateGenTable(GenTable genTable) {
        int row = this.genTableMapper.updateById(genTable);
        if (row > 0) {
            for (GenTableColumn cenTableColumn : genTable.getColumns()) {
                this.columnService.updateById(cenTableColumn);
            }
        }
    }

    @Override
    @Transactional
    public void deleteGenTableByIds(String ids) {
        this.genTableMapper.deleteBatchIds(Arrays.asList(Convert.toLongArray(ids)));
        this.genTableColumnMapper.deleteGenTableColumnByIds(Convert.toLongArray(ids));
    }

    @Override
    public void deleteGenTableById(long id) {
        GenTable genTable = new GenTable();
        genTable.setTableId(id);
        genTable.setIsValid(0);
        this.updateById(genTable);
        this.columnService.deleteByTableId(id);
    }

    @Override
    @Transactional
    public void importGenTable(List<GenTable> tableList, String operName) {
        for (GenTable table : tableList) {
            try {
                String tableName = table.getTableName();
                GenUtils.initTable(table, operName);
                int row = this.genTableMapper.insert(table);
                if (row <= 0) continue;
                List<GenTableColumn> genTableColumns = this.genTableColumnMapper.selectDbTableColumnsByName(tableName);
                for (GenTableColumn column : genTableColumns) {
                    GenUtils.initColumnField(column, table);
                }
                this.columnService.saveBatch(genTableColumns);
            }
            catch (Exception e) {
                log.error("\u8868\u540d " + table.getTableName() + " \u5bfc\u5165\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
    }

    public void setPkColumn(GenTable table, List<GenTableColumn> columns) {
        for (GenTableColumn column : columns) {
            if (!column.isPk()) continue;
            table.setPkColumn(column);
            break;
        }
        if (table.getPkColumn() == null) {
            table.setPkColumn(columns.get(0));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveOrUpdateGenTable(GenTable genTable) {
        if (StringUtils.isBlank((CharSequence)genTable.getModuleName())) {
            genTable.setModuleName("sys");
        }
        this.saveTbl(genTable);
        if (CollectionUtils.isNotEmpty(genTable.getSubTables())) {
            for (GenTable subtable : genTable.getSubTables()) {
                subtable.setProjectId(genTable.getProjectId());
                this.saveTbl(subtable);
            }
        }
        return true;
    }

    private void saveTbl(GenTable genTable) {
        GenTable existTb = this.findByTbNameProjectId(genTable.getTableName(), genTable.getProjectId());
        if (existTb != null) {
            genTable.setTableId(existTb.getTableId());
        }
        if (StringUtils.isBlank((CharSequence)genTable.getClassName())) {
            genTable.setClassName(StringUtils.convertToCamelCase(genTable.getTableName()));
        }
        if (StringUtils.isNotBlank((CharSequence)genTable.getClassName()) && StringUtils.isBlank((CharSequence)genTable.getBusinessName())) {
            genTable.setBusinessName(StringUtils.capitalize((String)genTable.getClassName()));
        }
        this.saveOrUpdate(genTable);
        List<GenTableColumn> existColumns = this.columnService.selectGenTableColumnListByTableId(genTable.getTableId());
        ArrayList<GenTableColumn> saveOrUpdateList = new ArrayList<GenTableColumn>();
        if (CollectionUtils.isNotEmpty(existColumns)) {
            Map<String, GenTableColumn> fromMap = genTable.getColumns().stream().collect(Collectors.toMap(GenTableColumn::getColumnName, tableColumn -> tableColumn));
            existColumns.forEach(column -> {
                if (!fromMap.containsKey(column.getColumnName())) {
                    column.setIsValid(0);
                    saveOrUpdateList.add((GenTableColumn)column);
                } else {
                    ((GenTableColumn)fromMap.get(column.getColumnName())).setColumnId(column.getColumnId());
                }
            });
            saveOrUpdateList.addAll(fromMap.values());
        } else {
            saveOrUpdateList.addAll(genTable.getColumns());
        }
        if (CollectionUtils.isNotEmpty(saveOrUpdateList)) {
            saveOrUpdateList.forEach(column -> {
                column.setTableId(genTable.getTableId());
                if (StringUtils.isBlank((CharSequence)column.getJavaField())) {
                    column.setJavaField(StringUtils.toCamelCase(column.getColumnName()));
                }
            });
            this.columnService.saveOrUpdateBatch(saveOrUpdateList);
        }
    }

    @Override
    public GenTable selectSimpleGenTableName(String tableName, String projectId) {
        GenTable table = (GenTable)this.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"table_name", (Object)tableName)).eq(StringUtils.isNotBlank((CharSequence)projectId), (Object)"project_id", (Object)projectId)).eq((Object)"is_valid", (Object)1));
        return table;
    }

    @Override
    public GenTable selectGenTableName(String tableName, String projectId) {
        GenTable table = this.findByTbNameProjectId(tableName, projectId);
        if (table == null) {
            return null;
        }
        List<GenTableColumn> columns = this.columnService.selectGenTableColumnListByTableId(table.getTableId());
        table.setColumns(columns);
        return table;
    }

    @Override
    public GenTable findByTbNameProjectId(String tbName, String projectId) {
        GenTable table = (GenTable)this.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"table_name", (Object)tbName)).eq(StringUtils.isNotBlank((CharSequence)projectId), (Object)"project_id", (Object)projectId)).eq((Object)"is_valid", (Object)1));
        return table;
    }

    @Override
    public PageUtils queryPager(GenTableParam param) {
        Page pageParam = new Page((long)param.getPage(), (long)param.getSize());
        IPage page = this.page((IPage)pageParam, (Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq(StringUtils.isNotBlank((CharSequence)param.getProjectId()), (Object)"project_id", (Object)param.getProjectId())).like(StringUtils.isNotBlank((CharSequence)param.getTableName()), (Object)"table_name", (Object)param.getTableName())).like(StringUtils.isNotBlank((CharSequence)param.getBusinessName()), (Object)"business_name", (Object)param.getBusinessName())).like(StringUtils.isNotBlank((CharSequence)param.getTableComment()), (Object)"table_comment", (Object)param.getTableComment())).eq((Object)"is_valid", (Object)1));
        return new PageUtils(page);
    }

    @Override
    public GenTable getRichById(String id) {
        GenTable table = (GenTable)this.getById((Serializable)((Object)id));
        if (table == null) {
            return null;
        }
        List<GenTableColumn> columns = this.columnService.selectGenTableColumnListByTableId(table.getTableId());
        table.setColumns(columns);
        return table;
    }

    @Override
    public GenTable getRichByBusinessName(String businessName) {
        GenTable table = (GenTable)this.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"business_name", (Object)businessName)).eq((Object)"is_valid", (Object)1));
        if (table == null) {
            return null;
        }
        List<GenTableColumn> columns = this.columnService.selectGenTableColumnListByTableId(table.getTableId());
        table.setColumns(columns);
        return table;
    }
}

