/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.generator.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;

public class ZipUtils {
    private ZipOutputStream out;
    private String zipFile;
    private String projectCode;

    public ZipUtils(String zipFile, String projectCode) throws IOException {
        this.out = new ZipOutputStream(new FileOutputStream(zipFile));
        this.zipFile = zipFile;
        this.projectCode = "bridgehead-" + projectCode;
    }

    public void doCompress(String srcFile) throws IOException {
        File file = new File(this.zipFile);
        this.doCompress(new File(srcFile));
    }

    public void doCompress(File srcFile) throws IOException {
        this.doCompress(srcFile, this.out);
    }

    public void doCompress(File file, ZipOutputStream out) throws IOException {
        this.doCompress(file, out, "");
    }

    public void doCompress(File inFile, ZipOutputStream out, String dir) throws IOException {
        if (inFile.isDirectory()) {
            File[] files = inFile.listFiles();
            if (files != null && files.length > 0) {
                for (File file : files) {
                    String name = inFile.getName();
                    if (!"".equals(dir)) {
                        name = dir + "/" + name;
                    }
                    this.doCompress(file, out, name);
                }
            }
        } else {
            this.doZip(inFile, out, dir);
        }
    }

    public void doZip(File inFile, ZipOutputStream out, String dir) throws IOException {
        int len;
        String entryName = null;
        entryName = !"".equals(dir) ? dir + "/" + inFile.getName() : inFile.getName();
        if (StringUtils.isNotEmpty((CharSequence)this.projectCode) && entryName.indexOf("/") > 0) {
            entryName = this.projectCode + entryName.substring(entryName.indexOf("/"));
        }
        ZipEntry entry = new ZipEntry(entryName);
        out.putNextEntry(entry);
        byte[] buffer = new byte[1024];
        FileInputStream fis = new FileInputStream(inFile);
        while ((len = fis.read(buffer)) > 0) {
            out.write(buffer, 0, len);
            out.flush();
        }
        out.closeEntry();
        fis.close();
    }

    public void close() throws IOException {
        if (null != this.out) {
            this.out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToZipFile(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                FileInputStream fis = null;
                BufferedInputStream bis = null;
                try {
                    int length;
                    fis = new FileInputStream(file);
                    bis = new BufferedInputStream(fis);
                    ZipEntry entry = new ZipEntry(file.getName());
                    this.out.putNextEntry(entry);
                    byte[] buffer = new byte[4096];
                    while ((length = bis.read(buffer)) != -1) {
                        this.out.write(buffer, 0, length);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        bis.close();
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                this.writeToZipFile(file.listFiles());
            }
        }
    }

    public ZipOutputStream getOut() {
        return this.out;
    }

    public void writeToZipFile(File[] files) {
        int length = files.length;
        for (int i = 0; i < length; ++i) {
            this.writeToZipFile(files[i]);
        }
    }

    public String getZipFile() {
        return this.zipFile;
    }

    public static void main(String[] args) throws IOException {
    }
}

