package com.xforceplus.janus.message.common.dto.admin;

import com.baomidou.mybatisplus.annotation.TableName;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Size;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * <p>
 * 业务表
 * </p>
 *
 * @author zhu jie
 * @since 2021-04-13
 */
@Data
@TableName("t_pub")
@ApiModel(value = "Pub对象", description = "业务表")
public class PubAddDTO {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "appKey", required = true)
    @NotEmpty
    private String appKey;

    @ApiModelProperty(value = "发布编码（全局唯一） 只能是英文、数字、短横线（-）、下划线（_）", required = true)
    @Size(max = 24)
    @NotEmpty
    private String pubCode;

    @ApiModelProperty(value = "MQ集群编码")
    private String mqClusterCode;

    @ApiModelProperty(value = "RocketMQ的topicName")
    private String topicName;

    @ApiModelProperty(value = "消息结构体")
    private String messageStruct;

    @ApiModelProperty(value = "描述")
    private String description;

    @ApiModelProperty(value = "每秒允许的请求次数")
    private Long permitsPerSecond;


}
