package com.xforceplus.janus.message.common.dto.api;

import com.xforceplus.janus.message.common.enums.FilterNodeTypeEnum;
import com.xforceplus.janus.shooter.core.entity.TagFilter;

import java.util.List;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 事件数据处理节点-过滤
 *
 * @author zhujie@xforceplus.com
 * @date 2021/1/26 10:36 AM
 **/
@Data
public class EventNodeConfigFilterDTO{

    /**
     * @see FilterNodeTypeEnum
     */
    @ApiModelProperty(value = "过滤类型 参考：FilterNodeTypeEnum")
    private String filterType;


    @ApiModelProperty(value = "敏感词租户ID")
    private String sensitiveWordTenantId;


    @ApiModelProperty(value = "过滤规则")
    private List<TagFilter> filters;
}
