package com.xforceplus.janus.message.common.enums;

public enum FilterNodeTypeEnum {

    SYSTEM("0", "系统"),

    EVENT("1", "事件"),

    FILTER_RULE("2", "过滤规则"),

    ;

    private String code;

    private String desc;

    FilterNodeTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static FilterNodeTypeEnum getByCode(String code) {
        for (FilterNodeTypeEnum i : values()) {
            if (i.getCode().equals(code)) {
                return i;
            }
        }
        throw new IllegalArgumentException("过滤类型没找到");
    }
}
