package com.xforceplus.janus.message.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;

import java.io.Serializable;
import java.time.Instant;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @program: message-bus-admin->BaseEntity
 * @description: base
 * @author: xuchuanhou
 * @create: 2021-03-10 11:48
 **/
@Data
public class BaseEntity implements Serializable, Cloneable {

    /**
     * id 主键
     */

    @TableId
    @ApiModelProperty(value = "ID")
    private String id;
    /**
     * 1-有效，0-无效
     */
    @TableField(value = "is_valid")
    @ApiModelProperty(value = "是否有效")
    private Integer isValid = Integer.valueOf(1);
    /**
     * 1-锁定，0-正常
     */
    @TableField(value = "is_lock")
    @ApiModelProperty(value = "是否锁定")
    private Integer isLock = Integer.valueOf(0);

    @TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(value = "创建者")
    private String creator;

    @TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(value = "创建时间")
    private Instant createdTime;

    @TableField(fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(value = "更新者")
    private String modifier;

    @TableField(fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(value = "更新时间")
    private Instant modifiedTime;

    public BaseEntity() {
    }

    public void clearBaseField() {
        this.setId(null);
        this.setCreator(null);
        this.setCreatedTime(null);
        this.setModifiedTime(null);
        this.setModifier(null);
    }
}