package com.xforceplus.janus.message.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.Instant;

/**
 * @program: message-bus-admin->BaseEntity
 * @description: base
 * @author: xuchuanhou
 * @create: 2021-03-10 11:48
 **/
@Data
public class BaseEntity implements Serializable, Cloneable {

    public static final String COL_ID            = "id";
    public static final String COL_IS_VALID      = "is_valid";
    public static final String COL_IS_LOCK       = "is_lock";
    public static final String COL_CREATOR       = "creator";
    public static final String COL_CREATED_TIME  = "created_time";
    public static final String COL_MODIFIER      = "modifier";
    public static final String COL_MODIFIED_TIME = "modified_time";

    /**
     * id 主键
     */
    @TableId
    @ApiModelProperty(value = "ID")
    private String  id;
    /**
     * 1-有效，0-无效
     */
    @TableField(value = COL_IS_VALID)
    @ApiModelProperty(value = "是否有效")
    private Integer isValid = Integer.valueOf(1);
    /**
     * 1-锁定，0-正常
     */
    @TableField(value = COL_IS_LOCK)
    @ApiModelProperty(value = "是否锁定")
    private Integer isLock  = Integer.valueOf(0);

    @TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(value = "创建者")
    private String creator;

    @TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(value = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Instant createdTime;

    @TableField(fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(value = "更新者")
    private String modifier;

    @TableField(fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(value = "更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Instant modifiedTime;

    public BaseEntity() {
    }

    public void clearBaseField() {
        this.setId(null);
        this.setCreator(null);
        this.setCreatedTime(null);
        this.setModifiedTime(null);
        this.setModifier(null);
    }
}
