/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.message.common.config;

import com.xforceplus.janus.message.common.config.ApplicationProperties;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Profile(value={"dev", "fat", "demo", "sit"})
@Configuration
@EnableSwagger2
@ConditionalOnProperty(prefix="application.swagger", value={"enabled"}, havingValue="true")
public class SwaggerConfig
implements WebMvcConfigurer {
    @Value(value="${spring.application.name}")
    private String appName;
    @Resource
    private ApplicationProperties applicationProperties;
    @Autowired
    private ServletContext servletContext;

    @Bean
    public Docket createRestApi() {
        Docket docket = new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.withMethodAnnotation(ApiOperation.class)).paths(PathSelectors.any()).build();
        if (this.applicationProperties.getAopAuth().isEnabled()) {
            docket.globalOperationParameters(this.buildGlobalParams());
        }
        return docket;
    }

    private List<Parameter> buildGlobalParams() {
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        ParameterBuilder appToken = new ParameterBuilder();
        appToken.name("mbToken").description("\u5e94\u7528\u4ee4\u724c").modelRef((ModelReference)new ModelRef("string")).parameterType("header").required(true).build();
        params.add(appToken.build());
        return params;
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.appName).description(this.appName).termsOfServiceUrl("https://www.xforceplus.com").version("3.0.0").build();
    }
}

