package com.xforceplus.janus.message.common.dto.api;

import com.xforceplus.janus.message.common.enums.TimeTypeEnum;

import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 事件消息分发-延时
 *
 * @author zhujie@xforceplus.com
 * @date 2021/1/26 10:37 AM
 **/
@Data
public class EventNodeConfigDelayDTO implements Serializable {

    /**
     * 延迟时间
     */
    @ApiModelProperty(value = "延时时间")
    private Integer delayTime;

    /**
     * 时间类型
     *
     * @see TimeTypeEnum
     */
    @ApiModelProperty(value = "延时类型：HOUR、MINUTE、SECOND")
    private String timeType;

    public long getMillisecond() {
        if (delayTime == null) {
            delayTime = 10;
        }
        if (StringUtils.isEmpty(timeType)) {
            timeType = TimeTypeEnum.SECOND.getCode();
        }

        long multiple = 1000;
        if (TimeTypeEnum.MINUTE.getCode().equals(timeType)) {
            multiple = multiple * 60;
        }
        if (TimeTypeEnum.HOUR.getCode().equals(timeType)) {
            multiple = multiple * 60 * 60;
        }

        return multiple * delayTime;
    }
}
