package com.xforceplus.janus.message.common.enums;

public enum MessageSourceEnum {

    MB("MB", "消息总线"),

    PUBSUB("PUBSUB", "PUBSUB"),

    JANUS("JANUS", "集成平台");

    private String code;

    private String desc;

    MessageSourceEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static MessageSourceEnum getByCode(String code) {
        for (MessageSourceEnum i : values()) {
            if (i.getCode().equalsIgnoreCase(code)) {
                return i;
            }
        }
        throw new IllegalArgumentException("消息来源没找到");
    }
}
