package com.xforceplus.janus.message.common.dto.api;


import java.util.List;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class TagFilterDTO {

    private static final long serialVersionUID = 1L;

    private String id;

    @ApiModelProperty(value = "事件ID")
    private String eventId;

    @ApiModelProperty(value = "0 代表是1级  当非0的时候，这pid 对应的 过滤条件只有sort_num其他字段不需要看")
    private String pid;

    @ApiModelProperty(value = "逻辑运算符 AND OR  第一个不存在")
    private String logicalOperators;

    @ApiModelProperty(value = "运算符：>：gt； >=：gte； =：eq； <：lt； <=：lte； like：lk; between：bwe；hasAttr；attrValueChange")
    private String operator;

    @ApiModelProperty(value = "属性名称，如果是多级用 . 来表示；如：a.[b].c.[d].e  []表示为数组")
    private String attrName;

    @ApiModelProperty(value = "属性类型 long string decimal")
    private String attrType;

    @ApiModelProperty(value = "属性值")
    private String attrVal;

    @ApiModelProperty(value = "子过滤条件")
    private List<TagFilterDTO> children;

}
