package com.xforceplus.janus.message.common.utils.kryo;

import com.xforceplus.janus.message.common.utils.kryo.io.KryoObjectInput;
import com.xforceplus.janus.message.common.utils.kryo.io.KryoObjectOutput;
import lombok.SneakyThrows;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class KryoRedisSerializer<T> implements RedisSerializer<T> {

    @SneakyThrows
    @Override
    public byte[] serialize(Object object) throws SerializationException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        KryoObjectOutput out = new KryoObjectOutput(KryoUtils.get(), bos);
        out.writeClassAndObject(object);
        out.flush();
        return bos.toByteArray();
    }

    @Override
    public T deserialize(byte[] data) throws SerializationException {
        if (data == null) {
            return null;
        }
        KryoObjectInput input = new KryoObjectInput(KryoUtils.get(), new ByteArrayInputStream(data));
        return input.readClassAndObject();
    }
}
