package com.xforceplus.janus.message.common.dto.admin;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.Instant;

/**
 * @author liuyao@xforceplus.com
 * @version 1.0
 * @date 2021/5/26 15:53
 */
@Data
public class ProcessSmsDTO extends ProcessNodeDTO {

    @ApiModelProperty(value = "消息处理名称")
    private String name;

    @ApiModelProperty(value = "短信模版代码")
    private String templateCode;

    @ApiModelProperty(value = "JSON格式的模板参数值，参数值只支持字符串类型，参数值顺序必须保持与模版内出现的顺序一致")
    private String templateParamJson;

    @ApiModelProperty(value = "短信内容")
    private String content;

    @ApiModelProperty(value = "短信签名")
    private String signature;

    @ApiModelProperty(value = "手机号提取规则ID,来自于filter_rule表的ID")
    private String extractMobileRuleId;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "是否有效")
    private Integer isValid = 1;

    @ApiModelProperty(value = "是否锁定")
    private Integer isLock = 0;

    @ApiModelProperty(value = "创建者")
    private String creator;

    @ApiModelProperty(value = "创建时间")
    private Instant createdTime;

    @ApiModelProperty(value = "更新者")
    private String modifier;

    @ApiModelProperty(value = "更新时间")
    private Instant modifiedTime;
}
