package com.xforceplus.janus.message.common.dto.api;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * @author zhujie@xforceplus.com
 * @date 2021/5/27 5:20 PM
 **/
@Data
public class QueryMessageCountDTO {

    private String pubAppKey;
    private String pubAppKeyName;

    private String pubCode;

    private String subAppKey;
    private String subAppKeyName;

    private Integer count;

    private Integer totalCount;

    @NotNull(message = "top不能为空")
    private Integer top;

//    @NotNull(message = "时间范围不能为空")
//    private Integer seconds;
    @ApiModelProperty(value = "消息发送的开始时间")
    @NotNull(message = "消息发送的开始时间不能为空")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss", iso = DateTimeFormat.ISO.DATE_TIME)
    private Date startTime;

    @ApiModelProperty(value = "消息发送的结束时间")
    @NotNull(message = "消息发送的结束时间不能为空")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss", iso = DateTimeFormat.ISO.DATE_TIME)
    private Date endTime;
}
