package com.xforceplus.janus.message.common.dto.mq;

import com.xforceplus.apollo.utils.JacksonUtil;
import lombok.Data;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

/**
 * @author tianyang
 * @date 2021/4/13 10:15 AM
 **/
@Data
public class KafkaMQConnectionConfigDTO extends MQConnectionConfig {
    //服务器地址
    private String bootstrapServers;
    // 0 发出去就确认 | 1 leader 落盘就确认| all 所有Follower同步完才确认
    private String acks;
    // 异常自动重试次数
    private Integer retries;
    // 多少条数据发送一次，默认16K
    private Long batchSize;
    // 批量发送的等待时间
    private Long lingerMs;
    // 客户端缓冲区大小，默认32M，满了也会触发消息发送
    private Long bufferMemory;
    // 获取元数据时生产者的阻塞时间，超时后抛出异常
    private Long maxBlockMs;
    // 是否自动提交偏移量，只有commit之后才更新消费组的 offset
    private String enableAutoCommit;
    // 消费者自动提交的间隔
    private Long autoCommitIntervalMs;
    // 从最早的数据开始消费 earliest | latest | none
    private String autoOffsetReset;
    // 设置每次拉取最大10条
    private Integer maxPollRecords;
    //分区数
    private Integer partitionSize;
    //副本数
    private Integer replicationSize;
//    {
//        "bootstrapServers": "47.98.38.105:9092,47.96.172.161:9092,47.97.210.13:9092,47.98.52.43:9092",
//            "maxPollRecords": 100,
//            "partitionSize": 3,
//            "replicationSize": 2,
//            "retries ": 3
//    }
//    public static void main(String[] args) {
//        KafkaMQConnectionConfigDTO kafkaMQConnectionConfigDTO = new KafkaMQConnectionConfigDTO();
//        kafkaMQConnectionConfigDTO.setBootstrapServers("47.98.38.105:9092,47.96.172.161:9092,47.97.210.13:9092,47.98.52.43:9092");
//        kafkaMQConnectionConfigDTO.setMaxPollRecords(100);
//        kafkaMQConnectionConfigDTO.setPartitionSize(3);
//        kafkaMQConnectionConfigDTO.setReplicationSize(2);
//        kafkaMQConnectionConfigDTO.setRetries(3);
//        String jsonstr= JacksonUtil.getInstance().toJson(kafkaMQConnectionConfigDTO);
//        System.out.println(jsonstr);
//        KafkaMQConnectionConfigDTO config = JacksonUtil.getInstance().fromJson(jsonstr, KafkaMQConnectionConfigDTO.class);
//        System.out.println(config);
//
//    }

}
