package com.xforceplus.janus.message.common.enums;

public enum PubSubTagTypeEnum {

    CONSTANT("CONSTANT", "常量"),

    EXPRESSION("EXPRESSION", "表达式"),

    ;

    private String code;

    private String desc;

    PubSubTagTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static PubSubTagTypeEnum getByCode(String code) {
        for (PubSubTagTypeEnum i : values()) {
            if (i.getCode().equals(code)) {
                return i;
            }
        }
        throw new IllegalArgumentException("过滤类型没找到");
    }
}
