package com.xforceplus.janus.message.common.utils;

import lombok.extern.slf4j.Slf4j;

import java.util.concurrent.*;

@Slf4j
public class ThreadPoolPubUtils {

    public static final ThreadPoolExecutor EXECUTOR = new ThreadPoolExecutor(16, 64, 60, TimeUnit.SECONDS, new ArrayBlockingQueue<>(200), new CustomerThreadFactory("pub-msg"), new ThreadPoolExecutor.CallerRunsPolicy());


    public static void execute(Runnable runnable) {
        EXECUTOR.execute(runnable);
    }

    public static <T> Future<T> submit(Callable<T> runnable) {
        return EXECUTOR.submit(runnable);
    }

}
