package com.xforceplus.janus.message.common.utils;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolReplayUtils {

    public static final ThreadPoolExecutor EXECUTOR = new ThreadPoolExecutor(1, 4, 60, TimeUnit.SECONDS, new ArrayBlockingQueue<>(16), new CustomerThreadFactory("replay"));

    public static void execute(Runnable runnable) {
        EXECUTOR.execute(runnable);
    }

    public static <T> Future<T> submit(Callable<T> runnable) {
        return EXECUTOR.submit(runnable);
    }

}
