/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.message.common.utils;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;

public class CustomerThreadFactory
implements ThreadFactory {
    private static final AtomicInteger threadNumber = new AtomicInteger(1);
    private final AtomicInteger mThreadNum = new AtomicInteger(1);
    private final String prefix;
    private final boolean daemoThread;
    private final ThreadGroup threadGroup;

    public CustomerThreadFactory() {
        this("server-threadpool-" + threadNumber.getAndIncrement(), false);
    }

    public CustomerThreadFactory(String prefix) {
        this(prefix, false);
    }

    public CustomerThreadFactory(String prefix, boolean daemo) {
        this.prefix = StringUtils.isNotEmpty((CharSequence)prefix) ? prefix + "-thread-" : "";
        this.daemoThread = daemo;
        SecurityManager s = System.getSecurityManager();
        this.threadGroup = s == null ? Thread.currentThread().getThreadGroup() : s.getThreadGroup();
    }

    @Override
    public Thread newThread(Runnable runnable) {
        String name = this.prefix + this.mThreadNum.getAndIncrement();
        Thread ret = new Thread(this.threadGroup, runnable, name, 0L);
        ret.setDaemon(this.daemoThread);
        return ret;
    }
}

