/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.message.common.utils;

import com.xforceplus.janus.message.common.utils.id.IdGenerator;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.MDC;

public class TraceIdUtils {
    public static final String TRACE_ID = "traceId";

    public static void setTraceId(HttpServletRequest request) {
        String traceId = Optional.ofNullable(request.getHeader(TRACE_ID)).orElse(TraceIdUtils.generateTraceId());
        MDC.put((String)TRACE_ID, (String)traceId);
    }

    public static void setTraceId(HttpServletResponse response) {
        Optional.ofNullable(response).ifPresent(resp -> resp.setHeader(TRACE_ID, MDC.get((String)TRACE_ID)));
    }

    public static String getTraceId() {
        return Optional.ofNullable(MDC.get((String)TRACE_ID)).orElse(TraceIdUtils.generateTraceId());
    }

    public static void remove() {
        MDC.remove((String)TRACE_ID);
    }

    public static void setParentMdcToChild(Map<String, String> context) {
        if (context == null) {
            MDC.clear();
        } else {
            MDC.setContextMap(context);
        }
        TraceIdUtils.putTraceIdIfAbsent();
    }

    private static String generateTraceId() {
        return "T" + IdGenerator.generateTimestampId();
    }

    private static void putTraceIdIfAbsent() {
        if (MDC.get((String)TRACE_ID) == null) {
            MDC.put((String)TRACE_ID, (String)TraceIdUtils.generateTraceId());
        }
    }
}

