/**
 * Copyright (c) 2016-2019 云砺信息科技 All rights reserved.
 *
 * https://www.xforceplus.com
 *
 * 版权所有，侵权必究！
 */

package com.xforceplus.janus.message.common.config;

import io.swagger.annotations.ApiOperation;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.paths.RelativePathProvider;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

import javax.annotation.Resource;
import javax.servlet.ServletContext;

import java.util.ArrayList;
import java.util.List;

import static com.xforceplus.janus.message.common.utils.JwtUtils.HEADER_MB_TOKEN_NAME;

@Configuration
@EnableSwagger2
@ConditionalOnProperty(prefix = "application.swagger", value = "enabled", havingValue = "true")
public class SwaggerConfig implements WebMvcConfigurer {

    @Value("${spring.application.name}")
    private String                appName;
    @Resource
    private ApplicationProperties applicationProperties;
    @Autowired
    private ServletContext        servletContext;

    @Bean
    public Docket createRestApi() {
        Docket docket = new Docket(DocumentationType.SWAGGER_2)
                .apiInfo(apiInfo())
                .select()
                //加了ApiOperation注解的类，才生成接口文档
                .apis(RequestHandlerSelectors.withMethodAnnotation(ApiOperation.class))
                //包下的类，才生成接口文档
                //.apis(RequestHandlerSelectors.basePackage("io.renren.controller"))
                .paths(PathSelectors.any())
                .build();

        if (applicationProperties.getAopAuth().isEnabled()) {
            docket.globalOperationParameters(buildGlobalParams());
        }
        return docket;
    }

    private List<Parameter> buildGlobalParams() {
        List<Parameter> params = new ArrayList<>();
        ParameterBuilder appToken = new ParameterBuilder();
        appToken.name(HEADER_MB_TOKEN_NAME).description("应用令牌").modelRef(new ModelRef("string")).parameterType("header")
                .required(true).build(); //header中的ticket参数非必填，传空也可以

        params.add(appToken.build());    //根据每个方法名也知道当前方法在设置什么参数
        return params;
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder()
                .title(appName)
                .description(appName)
                .termsOfServiceUrl("https://www.xforceplus.com")
                .version("3.0.0")
                .build();
    }
}
