package com.xforceplus.janus.message.common.dto.resp;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author tianyang
 * @date 2021/09/03 14:58
 **/
@Data
public class MessageOverstockStatisticsDTO {
    @ApiModelProperty(value = "发布编码（全局唯一） 只能是英文、数字、短横线（-）、下划线（_）")
    private String pubCode;

    @ApiModelProperty(value = "生产者appKey ")
    private String pubAppKey;

    @ApiModelProperty(value = "订阅appKey")
    private String subAppKey;

    @ApiModelProperty(value = "push数量")
    private Integer pushQuantity;

    @ApiModelProperty(value = "pull数量")
    private Integer pullQuantity;

    @ApiModelProperty(value = "ack数量")
    private Integer ackQuantity;

    @ApiModelProperty(value = "累计push数量")
    private Integer pushQuantityAddUp;

    @ApiModelProperty(value = "累计pull数量")
    private Integer pullQuantityAddUp;

    @ApiModelProperty(value = "累计ack数量")
    private Integer ackQuantityAddUp;

    @ApiModelProperty(value = "统计时间 格式 yyyy-mm-dd HH:MM")
    private String statisticsRegion;

    @ApiModelProperty(value = "创建时间")
    private Date    createdTime;
    @ApiModelProperty(value = "积压量")
    private Integer overstockQuantity;
    @ApiModelProperty(value = "回执率")
    private Double  ackRatio;
    @ApiModelProperty(value = "积压率")
    private Double  overstockRatio;
    @ApiModelProperty(value = "拉取(ms)")
    private Long pullTime;
    @ApiModelProperty(value = "业务耗时(ms)")
    private Long businessTime;

    private Long avgPullTime;
    @ApiModelProperty(value = "平均业务耗时(ms)")
    private Long avgBusinessTime;
}
