package com.xforceplus.janus.message.sdk.response;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.janus.message.sdk.core.AbsMbResponse;
import com.xforceplus.janus.message.sdk.core.HttpResp;
import com.xforceplus.janus.message.sdk.core.Result;
import com.xforceplus.janus.message.sdk.dto.SubRuleDetailDto;

import org.apache.http.HttpStatus;

import java.util.List;

/**
 * @author zhujie@xforceplus.com
 * @date 2021/5/10 9:43 AM
 **/
public class ListSubRuleResponse extends AbsMbResponse<ListSubRuleResponse> {

    private List<SubRuleDetailDto> subRuleDetailDtos;

    public List<SubRuleDetailDto> getSubRuleDetailDtos() {
        return subRuleDetailDtos;
    }

    public void setSubRuleDetailDtos(List<SubRuleDetailDto> subRuleDetailDtos) {
        this.subRuleDetailDtos = subRuleDetailDtos;
    }

    public static ListSubRuleResponse transform(HttpResp httpResp) {
        ListSubRuleResponse response = new ListSubRuleResponse();
        response.setSuccess(true);
        if (httpResp.getHttpStatus() != HttpStatus.SC_OK) {
            response.setSuccess(false);
            response.setError(httpResp.getRespStr());
            return response;
        }
        ObjectMapper mapper = new ObjectMapper();

        Result<List<SubRuleDetailDto>> result = null;
        try {
            result = mapper.readValue(httpResp.getRespStr(), new TypeReference<Result<List<SubRuleDetailDto>>>() {
            });
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }

        if (!Result.ResultCode.OK.getCode().equals(result.getCode())) {
            response.setSuccess(false);
            response.setError(result.getMessage());
        }
        response.setSubRuleDetailDtos(result.getResult());

        return response;
    }
}
