package com.xforceplus.janus.message.sdk.request;

import com.xforceplus.janus.message.sdk.Constants;
import com.xforceplus.janus.message.sdk.core.AbsMbRequest;
import com.xforceplus.janus.message.sdk.response.ListSubRuleResponse;

import java.util.HashMap;
import java.util.Map;

/**
 * @author zhujie@xforceplus.com
 * @date 2021/5/10 9:43 AM
 **/
public class ListSubRuleRequest extends AbsMbRequest<ListSubRuleResponse> {

    private String subAppKey;

    public ListSubRuleRequest(String subAppKey) {
        this.subAppKey = subAppKey;
    }

    @Override
    public String httpMethod() {
        return Constants.HTTP_METHOD_GET;
    }

    @Override
    public String getParamJson() {
        return null;
    }

    @Override
    public Map<String, String> getParam() {
        Map<String, String> param = new HashMap<>();
        param.put("subAppKey", subAppKey);
        return param;
    }

    @Override
    public String getRequestPath() {
        return Constants.MB_REQUEST_PATH_LIST_SUB_RULE;
    }

    @Override
    public Class<ListSubRuleResponse> getResponseClass() {
        return ListSubRuleResponse.class;
    }
}
