package com.xforceplus.janus.message.sdk;


import org.apache.commons.collections.MapUtils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * 请求消息
 *
 * @author zhujie@xforceplus.com
 * @date 2021/3/3 2:53 PM
 **/

/**
 * 请求消息
 */
public class RequestMessage implements Serializable {

    public static final String BUSINESS_NO_POP = "businessNo";

    public static final String COMPRESS_FLAG = "compressFlag";

    public static final String COMPRESS_FLAG_FALSE = "false";

    public static final String COMPRESS_FLAG_TRUE = "true";

    /**
     * 消息内容 JSON
     */
    private String content;

    /**
     * 消息属性Map
     */
    private Map<String, String> properties;

    /**
     * 发送时间戳，用来记录生产者发送消息时间点
     */
    private long sentTime;

    /**
     * 生产者发送成功后回调地址
     */
    private String callbackUrl;

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Map<String, String> getProperties() {
        if (MapUtils.isEmpty(properties)) {
            properties = new HashMap<>();
        }
        return properties;
    }

    /**
     * 批量添加属性
     *
     * @param properties 属性map
     */
    public void addProperties(Map<String, String> properties) {
        getProperties().putAll(properties);
    }

    /**
     * 添加单个属性
     *
     * @param key   key
     * @param value value
     */
    public void addProperty(String key, String value) {
        getProperties().put(key, value);
    }

    public long getSentTime() {
        return sentTime;
    }

    public void setSentTime(long sentTime) {
        this.sentTime = sentTime;
    }

    public String getCallbackUrl() {
        return callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    /**
     * 设置业务唯一编码
     *
     * @param businessNo 业务唯一编码
     */
    public void setBusinessNo(String businessNo) {
        getProperties().put(BUSINESS_NO_POP, businessNo);
    }
}
