package com.xforceplus.janus.message.sdk.request;

import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.message.sdk.Constants;
import com.xforceplus.janus.message.sdk.RequestMessage;
import com.xforceplus.janus.message.sdk.core.AbsMbRequest;
import com.xforceplus.janus.message.sdk.response.PubResponse;

import java.util.Map;

/**
 * @author zhujie@xforceplus.com
 * @date 2021/5/10 9:41 AM
 **/
public class PubRequest extends AbsMbRequest<PubResponse> {

    private String pubCode;

    private RequestMessage requestMessage;

    public PubRequest(String pubCode, RequestMessage requestMessage) {
        this.pubCode = pubCode;
        this.requestMessage = requestMessage;
    }

    public String getPubCode() {
        return pubCode;
    }

    public void setPubCode(String pubCode) {
        this.pubCode = pubCode;
    }

    public RequestMessage getRequestMessage() {
        return requestMessage;
    }

    public void setRequestMessage(RequestMessage requestMessage) {
        this.requestMessage = requestMessage;
    }

    @Override
    public String getRequestPath() {
        return Constants.MB_REQUEST_PATH_PUB + this.getPubCode();
    }

    @Override
    public Class<PubResponse> getResponseClass() {
        return PubResponse.class;
    }

    @Override
    public String httpMethod() {
        return Constants.HTTP_METHOD_POST;
    }

    @Override
    public String getParamJson() {
        return JacksonUtil.getInstance().toJson(getRequestMessage());
    }

    @Override
    public Map<String, String> getParam() {
        return null;
    }
}
