package com.xforceplus.janus.message.sdk.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;

/**
 * 消息回执对象
 *
 * @author 许传厚@xforceplus.com
 * @date 2021/3/11 2:53 PM
 **/
@JsonIgnoreProperties(ignoreUnknown = true)
public class MessageAck implements Serializable {

    private String receiptHandle;
    private String mqType;
    private String mqClusterCode;
    private String topicName;
    private String subAppKey;
    private String pubAppKey;
    private String pubCode;
    private Long messageId;
    private String thirdPartyId;

    private boolean status = true;
    private String message;

    public MessageAck() {

    }

    public String getReceiptHandle() {
        return receiptHandle;
    }

    public void setReceiptHandle(String receiptHandle) {
        this.receiptHandle = receiptHandle;
    }

    public String getConsumerKey() {
        return this.topicName + subAppKey;
    }

    public String getMqType() {
        return mqType;
    }

    public void setMqType(String mqType) {
        this.mqType = mqType;
    }

    public String getMqClusterCode() {
        return mqClusterCode;
    }

    public void setMqClusterCode(String mqClusterCode) {
        this.mqClusterCode = mqClusterCode;
    }

    public String getTopicName() {
        return topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public String getSubAppKey() {
        return subAppKey;
    }

    public void setSubAppKey(String subAppKey) {
        this.subAppKey = subAppKey;
    }

    public String getPubAppKey() {
        return pubAppKey;
    }

    public void setPubAppKey(String pubAppKey) {
        this.pubAppKey = pubAppKey;
    }

    public String getPubCode() {
        return pubCode;
    }

    public void setPubCode(String pubCode) {
        this.pubCode = pubCode;
    }

    public Long getMessageId() {
        return messageId;
    }

    public void setMessageId(Long messageId) {
        this.messageId = messageId;
    }

    public String getThirdPartyId() {
        return thirdPartyId;
    }

    public void setThirdPartyId(String thirdPartyId) {
        this.thirdPartyId = thirdPartyId;
    }

    public boolean isStatus() {
        return status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
