package com.xforceplus.janus.message.monitor;

import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.WorkHandler;
import com.xforceplus.apollo.utils.DateFormatUtil;
import com.xforceplus.janus.message.common.enums.Constants;
import com.xforceplus.janus.message.core.service.IMessageTraceService;
import com.xforceplus.janus.message.entity.MessageTrace;
import com.xforceplus.janus.message.uitls.UniqIdUtils;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;

/**
 * @author zhujie@xforceplus.com
 * @date 2021/2/5 1:36 PM
 **/
@Slf4j
@Component
public class MessageStatisticsEventHandler implements EventHandler<MessageStatisticsEvent>, WorkHandler<MessageStatisticsEvent> {

    @Autowired
    IMessageTraceService messageTraceService;

    @Override
    public void onEvent(MessageStatisticsEvent event, long sequence, boolean endOfBatch) throws Exception {
        MessageTrace messageTrace = new MessageTrace();
        MessageStatistics statistics = event.getMessageStatistics();
        String idStr = UniqIdUtils.getInstance().getUniqID();
        messageTrace.setMessageId(statistics.getMessageId());
        messageTrace.setNodeName(statistics.getProcessStep());
        messageTrace.setRemark(statistics.getEventId());
        messageTrace.setMessageId(statistics.getMessageId());
        messageTrace.setTimeSpent(statistics.getTimeSpent());
        messageTrace.setId(idStr);
        messageTrace.setIsValid(Constants.IS_VALIDED);
        messageTrace.setIsLock(Constants.IS_NOT_LOCKED);
        messageTrace.setCreator("1");
        messageTrace.setCreatedTime(DateFormatUtil.getCurrentFormatDateTime());
        messageTrace.setModifier("1");
        messageTrace.setModifiedTime(DateFormatUtil.getCurrentFormatDateTime());

        log.info("event: {}, sequence: {}, endOfBatch: {}", event, sequence, endOfBatch);
        messageTraceService.save(messageTrace);
    }

    @Override
    public void onEvent(MessageStatisticsEvent event) throws Exception {
        log.info("event: {}", event);

    }
}
