package com.xforceplus.jcaunteajenny.controller;


/**
 * 人员角色关系系统对象feign客户端
 *
 * @author ultraman
 * @date 2025-10-13
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcaunteajenny.entity.SystemRelRoleUser;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-auntea-jenny")
public interface SystemRelRoleUserFeignApi {

  /**
   * 通过id查询人员角色关系系统对象
   * @param  id
   * @return R
   */
  @GetMapping("/systemRelRoleUser/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增人员角色关系系统对象
   * @param systemRelRoleUser 人员角色关系系统对象
   * @return R
   */
  @PostMapping("/systemRelRoleUser/add")
  public R save(@RequestBody SystemRelRoleUser systemRelRoleUser);

  /**
   * 修改人员角色关系系统对象
   * @param systemRelRoleUser 人员角色关系系统对象
   * @return R
   */
  @PostMapping("/systemRelRoleUser/update")
  public R updateById(@RequestBody SystemRelRoleUser systemRelRoleUser);

  /**
   * 通过id删除人员角色关系系统对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/systemRelRoleUser/del/{id}" )
  public R removeById(@PathVariable Long id);

}