package com.xforceplus.jcaunteajenny.controller;


/**
 * 系统流程节点实例历史对象feign客户端
 *
 * @author ultraman
 * @date 2025-10-14
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcaunteajenny.entity.SysFlowActInsHis;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-auntea-jenny")
public interface SysFlowActInsHisFeignApi {

  /**
   * 通过id查询系统流程节点实例历史对象
   * @param  id
   * @return R
   */
  @GetMapping("/sysFlowActInsHis/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增系统流程节点实例历史对象
   * @param sysFlowActInsHis 系统流程节点实例历史对象
   * @return R
   */
  @PostMapping("/sysFlowActInsHis/add")
  public R save(@RequestBody SysFlowActInsHis sysFlowActInsHis);

  /**
   * 修改系统流程节点实例历史对象
   * @param sysFlowActInsHis 系统流程节点实例历史对象
   * @return R
   */
  @PostMapping("/sysFlowActInsHis/update")
  public R updateById(@RequestBody SysFlowActInsHis sysFlowActInsHis);

  /**
   * 通过id删除系统流程节点实例历史对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/sysFlowActInsHis/del/{id}" )
  public R removeById(@PathVariable Long id);

}