package com.xforceplus.jcaunteajenny.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 组织扩展字段系统对象
 * </p>
 *
 * @author ultraman
 * @since 2025-10-21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SystemExtendField implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 字段名称
   */
  private String name;

  /**
   * 字段编码
   */
  private String code;

  /**
   * 是否数组
   */
  private Boolean arrayType;

  /**
   * 字段类型
   */
  private String fieldType;

  /**
   * 字典id
   */
  private String dictId;

  /**
   * 主键标识
   */
  private String fieldKey;

  /**
   * 缺省值
   */
  private String defaultValue;

  /**
   * 显示位置
   */
  private Long sortPlace;

  /**
   * 字段说明信息
   */
  private String remark;

  /**
   * 系统类型（系统/用户）
   */
  private String sysType;

  /**
   * 是否可编辑
   */
  private Boolean editable;

  /**
   * 别名
   */
  private String alias;

  /**
   * 值类型
   */
  private String valueType;

  /**
   * 是否动态字段
   */
  private Boolean dynamic;

  /**
   * 校验规则
   */
  private String validateRule;

  /**
   * 长度
   */
  private Long length;

  /**
   * 小数点
   */
  private Long decimalPoint;

  /**
   * 是否可搜索
   */
  private Boolean searchable;

  /**
   * 是否必须
   */
  private Boolean required;

  /**
   * 是否唯一
   */
  private Boolean unique;

  /**
   * 字段描述类型
   */
  private String describeType;

  /**
   * 是否锁定-锁定后不允许调整其他配置
   */
  private Boolean locked;

  /**
   * 模糊类型 未知0 不作处理1 通配符2 分词3
   */
  private String fuzzyType;

  /**
   * 通配符最小长度
   */
  private Long wildcardMinWidth;

  /**
   * 通配符最大长度
   */
  private Long wildcardMaxWidth;

  /**
   * 被扩展对象编码
   */
  private String boCode;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("name", name);
      map.put("code", code);
      map.put("array_type", arrayType);
      map.put("field_type", fieldType);
      map.put("dict_id", dictId);
      map.put("field_key", fieldKey);
      map.put("default_value", defaultValue);
      map.put("sort_place", sortPlace);
      map.put("remark", remark);
      map.put("sys_type", sysType);
      map.put("editable", editable);
      map.put("alias", alias);
      map.put("value_type", valueType);
      map.put("dynamic", dynamic);
      map.put("validate_rule", validateRule);
      map.put("length", length);
      map.put("decimal_point", decimalPoint);
      map.put("searchable", searchable);
      map.put("required", required);
      map.put("unique", unique);
      map.put("describe_type", describeType);
      map.put("locked", locked);
      map.put("fuzzy_type", fuzzyType);
      map.put("wildcard_min_width", wildcardMinWidth);
      map.put("wildcard_max_width", wildcardMaxWidth);
      map.put("bo_code", boCode);
      map.put("org_tree", orgTree);

      return map;
  }

  public static SystemExtendField fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    SystemExtendField entity = new SystemExtendField();
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("name")) {
      Object obj = map.get("name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("code")) {
      Object obj = map.get("code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("array_type")) {
      Object obj = map.get("array_type");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setArrayType((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setArrayType(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("field_type")) {
      Object obj = map.get("field_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFieldType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dict_id")) {
      Object obj = map.get("dict_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDictId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("field_key")) {
      Object obj = map.get("field_key");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFieldKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("default_value")) {
      Object obj = map.get("default_value");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDefaultValue((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sort_place")) {
      Object obj = map.get("sort_place");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSortPlace((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSortPlace(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSortPlace(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sys_type")) {
      Object obj = map.get("sys_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSysType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("editable")) {
      Object obj = map.get("editable");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setEditable((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEditable(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("alias")) {
      Object obj = map.get("alias");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAlias((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("value_type")) {
      Object obj = map.get("value_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setValueType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dynamic")) {
      Object obj = map.get("dynamic");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setDynamic((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDynamic(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("validate_rule")) {
      Object obj = map.get("validate_rule");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setValidateRule((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("length")) {
      Object obj = map.get("length");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLength((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLength(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLength(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("decimal_point")) {
      Object obj = map.get("decimal_point");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDecimalPoint((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDecimalPoint(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDecimalPoint(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("searchable")) {
      Object obj = map.get("searchable");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setSearchable((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSearchable(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("required")) {
      Object obj = map.get("required");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setRequired((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRequired(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("unique")) {
      Object obj = map.get("unique");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setUnique((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUnique(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("describe_type")) {
      Object obj = map.get("describe_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDescribeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("locked")) {
      Object obj = map.get("locked");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLocked((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLocked(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("fuzzy_type")) {
      Object obj = map.get("fuzzy_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFuzzyType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("wildcard_min_width")) {
      Object obj = map.get("wildcard_min_width");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setWildcardMinWidth((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setWildcardMinWidth(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setWildcardMinWidth(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("wildcard_max_width")) {
      Object obj = map.get("wildcard_max_width");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setWildcardMaxWidth((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setWildcardMaxWidth(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setWildcardMaxWidth(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("bo_code")) {
      Object obj = map.get("bo_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBoCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("name")) {
      Object obj = map.get("name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("code")) {
      Object obj = map.get("code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("array_type")) {
      Object obj = map.get("array_type");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setArrayType((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setArrayType(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("field_type")) {
      Object obj = map.get("field_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFieldType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dict_id")) {
      Object obj = map.get("dict_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDictId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("field_key")) {
      Object obj = map.get("field_key");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFieldKey((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("default_value")) {
      Object obj = map.get("default_value");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDefaultValue((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sort_place")) {
      Object obj = map.get("sort_place");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSortPlace((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSortPlace(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSortPlace(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sys_type")) {
      Object obj = map.get("sys_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSysType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("editable")) {
      Object obj = map.get("editable");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setEditable((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setEditable(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("alias")) {
      Object obj = map.get("alias");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAlias((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("value_type")) {
      Object obj = map.get("value_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setValueType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dynamic")) {
      Object obj = map.get("dynamic");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setDynamic((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDynamic(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("validate_rule")) {
      Object obj = map.get("validate_rule");
      if(obj != null) {
        if(obj instanceof String) {
          this.setValidateRule((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("length")) {
      Object obj = map.get("length");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setLength((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLength(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setLength(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("decimal_point")) {
      Object obj = map.get("decimal_point");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDecimalPoint((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDecimalPoint(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setDecimalPoint(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("searchable")) {
      Object obj = map.get("searchable");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setSearchable((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSearchable(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("required")) {
      Object obj = map.get("required");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setRequired((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRequired(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("unique")) {
      Object obj = map.get("unique");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setUnique((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUnique(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("describe_type")) {
      Object obj = map.get("describe_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDescribeType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("locked")) {
      Object obj = map.get("locked");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setLocked((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLocked(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("fuzzy_type")) {
      Object obj = map.get("fuzzy_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFuzzyType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("wildcard_min_width")) {
      Object obj = map.get("wildcard_min_width");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setWildcardMinWidth((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setWildcardMinWidth(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setWildcardMinWidth(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("wildcard_max_width")) {
      Object obj = map.get("wildcard_max_width");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setWildcardMaxWidth((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setWildcardMaxWidth(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setWildcardMaxWidth(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("bo_code")) {
      Object obj = map.get("bo_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBoCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
