package com.xforceplus.jcaunteajenny.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcaunteajenny.entity.SysFlowInsHis;
import com.xforceplus.jcaunteajenny.service.ISysFlowInsHisService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 系统工作流流程实例历史对象前端控制器
 *
 * @author ultraman
 * @date 2025-10-14
 */
@RestController
public class SysFlowInsHisController {

  @Autowired
  private ISysFlowInsHisService sysFlowInsHisServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param sysFlowInsHis 系统工作流流程实例历史对象
   * @return
   */
  @GetMapping("/sysflowinshiss" )
  public XfR getSysFlowInsHiss(XfPage page, SysFlowInsHis sysFlowInsHis) {
    return XfR.ok(sysFlowInsHisServiceImpl.page(page, Wrappers.query(sysFlowInsHis)));
  }

  /**
   * 通过id查询系统工作流流程实例历史对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/sysflowinshiss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(sysFlowInsHisServiceImpl.getById(id));
  }

  /**
   * 新增系统工作流流程实例历史对象
   * @param sysFlowInsHis 系统工作流流程实例历史对象
   * @return XfR
   */
  @PostMapping("/sysflowinshiss")
  public XfR save(@RequestBody SysFlowInsHis sysFlowInsHis) {
     return XfR.ok(sysFlowInsHisServiceImpl.save(sysFlowInsHis));
  }

  /**
   * 修改-传入修改后的全部数据系统工作流流程实例历史对象
   * @param sysFlowInsHis 系统工作流流程实例历史对象
   * @return XfR
   */
  @PutMapping("/sysflowinshiss/{id}")
  public XfR putUpdate(@RequestBody SysFlowInsHis sysFlowInsHis,@PathVariable Long id) {
      sysFlowInsHis.setId(id);
      return XfR.ok(sysFlowInsHisServiceImpl.updateById(sysFlowInsHis));
  }

  /**
   * 修改-传入修改的数据系统工作流流程实例历史对象
   * @param sysFlowInsHis 系统工作流流程实例历史对象
   * @return XfR
   */
  @PatchMapping("/sysflowinshiss/{id}")
  public XfR patchUpdate(@RequestBody SysFlowInsHis sysFlowInsHis,@PathVariable Long id) {
      SysFlowInsHis upsysFlowInsHis = sysFlowInsHisServiceImpl.getById(id);
      if(upsysFlowInsHis != null){
        upsysFlowInsHis = ObjectCopyUtils.copyProperties(sysFlowInsHis,upsysFlowInsHis,true);
      }
      return XfR.ok(sysFlowInsHisServiceImpl.updateById(upsysFlowInsHis));
  }

  /**
   * 通过id删除系统工作流流程实例历史对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/sysflowinshiss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(sysFlowInsHisServiceImpl.removeById(id));
  }

  @PostMapping("/sysflowinshiss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sys_flow_ins_his");
     params.put("request", condition);

     return XfR.ok(sysFlowInsHisServiceImpl.querys(params));
  }

}
