package com.xforceplus.jcaunteajenny.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcaunteajenny.entity.SystemInbox;
import com.xforceplus.jcaunteajenny.service.ISystemInboxService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 系统站内信对象前端控制器
 *
 * @author ultraman
 * @date 2025-10-21
 */
@RestController
public class SystemInboxController {

  @Autowired
  private ISystemInboxService systemInboxServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param systemInbox 系统站内信对象
   * @return
   */
  @GetMapping("/systeminboxs" )
  public XfR getSystemInboxs(XfPage page, SystemInbox systemInbox) {
    return XfR.ok(systemInboxServiceImpl.page(page, Wrappers.query(systemInbox)));
  }

  /**
   * 通过id查询系统站内信对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/systeminboxs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(systemInboxServiceImpl.getById(id));
  }

  /**
   * 新增系统站内信对象
   * @param systemInbox 系统站内信对象
   * @return XfR
   */
  @PostMapping("/systeminboxs")
  public XfR save(@RequestBody SystemInbox systemInbox) {
     return XfR.ok(systemInboxServiceImpl.save(systemInbox));
  }

  /**
   * 修改-传入修改后的全部数据系统站内信对象
   * @param systemInbox 系统站内信对象
   * @return XfR
   */
  @PutMapping("/systeminboxs/{id}")
  public XfR putUpdate(@RequestBody SystemInbox systemInbox,@PathVariable Long id) {
      systemInbox.setId(id);
      return XfR.ok(systemInboxServiceImpl.updateById(systemInbox));
  }

  /**
   * 修改-传入修改的数据系统站内信对象
   * @param systemInbox 系统站内信对象
   * @return XfR
   */
  @PatchMapping("/systeminboxs/{id}")
  public XfR patchUpdate(@RequestBody SystemInbox systemInbox,@PathVariable Long id) {
      SystemInbox upsystemInbox = systemInboxServiceImpl.getById(id);
      if(upsystemInbox != null){
        upsystemInbox = ObjectCopyUtils.copyProperties(systemInbox,upsystemInbox,true);
      }
      return XfR.ok(systemInboxServiceImpl.updateById(upsystemInbox));
  }

  /**
   * 通过id删除系统站内信对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/systeminboxs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(systemInboxServiceImpl.removeById(id));
  }

  @PostMapping("/systeminboxs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "system_inbox");
     params.put("request", condition);

     return XfR.ok(systemInboxServiceImpl.querys(params));
  }

}
