package com.xforceplus.jcbabemax.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * main_audit_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-14
 */
public enum MainAuditStatus {

    _0("0", "待审核"),
    _1("1", "审核完成"),
    _99("99", "待人工审核");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    MainAuditStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MainAuditStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "99":
                return _99;
            default:
                return null;
        }
    }
}
