package com.xforceplus.jcbabemax.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * order_type
 * </p>
 *
 * @author ultraman
 * @since 2025-10-14
 */
public enum OrderType {

    SALES("sales", "销售单"),
    SALES_RETURN("salesReturn", "退货单");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    OrderType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OrderType fromCode(String code){
        switch(code) {
            case "sales":
                return SALES;
            case "salesReturn":
                return SALES_RETURN;
            default:
                return null;
        }
    }
}
