package com.xforceplus.jcbabemax.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * red_type
 * </p>
 *
 * @author ultraman
 * @since 2025-10-14
 */
public enum RedType {

    RETURN_RED("returnRed", "退货红冲"),
    CHANGE_RED("changeRed", "换开红冲");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    RedType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RedType fromCode(String code){
        switch(code) {
            case "returnRed":
                return RETURN_RED;
            case "changeRed":
                return CHANGE_RED;
            default:
                return null;
        }
    }
}
