package com.xforceplus.jcbabemax.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2025-03-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BillIteam implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 含税金额
   */
  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  /**
   * 不含税金额
   */
  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  /**
   * 税额
   */
  @TableField("taxAmount")
  private BigDecimal taxAmount;

  /**
   * 税收分类编码
   */
  @TableField("goodsTaxNo")
  private String goodsTaxNo;

  /**
   * 发票类型
   */
  @TableField("invoiceType")
  private String invoiceType;

  /**
   * 商品代码
   */
  @TableField("itemCode")
  private String itemCode;

  /**
   * 货物及服务名称
   */
  @TableField("itemName")
  private String itemName;

  /**
   * 品名
   */
  @TableField("itemShortName")
  private String itemShortName;

  /**
   * 明细规格型号
   */
  @TableField("itemSpec")
  private String itemSpec;

  /**
   * 行业特殊票种类型
   */
  @TableField("itemTypeCode")
  private String itemTypeCode;

  /**
   * 大类名称
   */
  @TableField("largeCategoryName")
  private String largeCategoryName;

  /**
   * 来源
   */
  private String origin;

  /**
   * 数量
   */
  private BigDecimal quantity;

  /**
   * 数量单位
   */
  @TableField("quantityUnit")
  private String quantityUnit;

  /**
   * 发票备注
   */
  private String remark;

  /**
   * 业务单明细号
   */
  @TableField("salesbillItemNo")
  private String salesbillItemNo;

  /**
   * 类型
   */
  @TableField("salesbillItemType")
  private String salesbillItemType;

  /**
   * 业务单号
   */
  @TableField("salesbillNo")
  private String salesbillNo;

  /**
   * 零税率标志
   */
  @TableField("zeroTax")
  private String zeroTax;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 组织树
   */
  private String orgTree;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;


  /**
   * 对一关联关系 关联对象 billMain
   */
    private Long billToIteamManyId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("amountWithTax", amountWithTax);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxAmount", taxAmount);
      map.put("goodsTaxNo", goodsTaxNo);
      map.put("invoiceType", invoiceType);
      map.put("itemCode", itemCode);
      map.put("itemName", itemName);
      map.put("itemShortName", itemShortName);
      map.put("itemSpec", itemSpec);
      map.put("itemTypeCode", itemTypeCode);
      map.put("largeCategoryName", largeCategoryName);
      map.put("origin", origin);
      map.put("quantity", quantity);
      map.put("quantityUnit", quantityUnit);
      map.put("remark", remark);
      map.put("salesbillItemNo", salesbillItemNo);
      map.put("salesbillItemType", salesbillItemType);
      map.put("salesbillNo", salesbillNo);
      map.put("zeroTax", zeroTax);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

       map.put("billToIteamMany.id", billToIteamManyId);
      return map;
  }

  public static BillIteam fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BillIteam entity = new BillIteam();
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("goodsTaxNo")) {
      Object obj = map.get("goodsTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemName")) {
      Object obj = map.get("itemName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemShortName")) {
      Object obj = map.get("itemShortName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemShortName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemSpec")) {
      Object obj = map.get("itemSpec");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemTypeCode")) {
      Object obj = map.get("itemTypeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("largeCategoryName")) {
      Object obj = map.get("largeCategoryName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLargeCategoryName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin")) {
      Object obj = map.get("origin");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrigin((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("quantityUnit")) {
      Object obj = map.get("quantityUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setQuantityUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesbillItemNo")) {
      Object obj = map.get("salesbillItemNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesbillItemNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesbillItemType")) {
      Object obj = map.get("salesbillItemType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesbillItemType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesbillNo")) {
      Object obj = map.get("salesbillNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesbillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zeroTax")) {
      Object obj = map.get("zeroTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZeroTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("billToIteamMany.id")) {
        Object obj = map.get("billToIteamMany.id");
      if(obj instanceof Long) {
        entity.setBillToIteamManyId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setBillToIteamManyId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("goodsTaxNo")) {
      Object obj = map.get("goodsTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemName")) {
      Object obj = map.get("itemName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemShortName")) {
      Object obj = map.get("itemShortName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemShortName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemSpec")) {
      Object obj = map.get("itemSpec");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemSpec((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemTypeCode")) {
      Object obj = map.get("itemTypeCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemTypeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("largeCategoryName")) {
      Object obj = map.get("largeCategoryName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLargeCategoryName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("origin")) {
      Object obj = map.get("origin");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrigin((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("quantityUnit")) {
      Object obj = map.get("quantityUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setQuantityUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesbillItemNo")) {
      Object obj = map.get("salesbillItemNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesbillItemNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesbillItemType")) {
      Object obj = map.get("salesbillItemType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesbillItemType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesbillNo")) {
      Object obj = map.get("salesbillNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesbillNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zeroTax")) {
      Object obj = map.get("zeroTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZeroTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("billToIteamMany.id")) {
        Object obj = map.get("billToIteamMany.id");
        if(obj instanceof Long) {
          this.setBillToIteamManyId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBillToIteamManyId(Long.parseLong((String)obj));
        }
      }
  }
}
