package com.xforceplus.jcbabemax.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2025-03-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OrderPool implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 订单号
   */
  @TableField("bizOrderNo")
  private String bizOrderNo;

  /**
   * 门店号
   */
  @TableField("orgCode")
  private String orgCode;

  /**
   * 计价方式
   */
  @TableField("pricingMethod")
  private String pricingMethod;

  /**
   * 含税金额
   */
  @TableField("amountWithTax")
  private String amountWithTax;

  /**
   * 不含税金额
   */
  @TableField("amountWithoutTax")
  private String amountWithoutTax;

  /**
   * 税额
   */
  @TableField("taxAmount")
  private String taxAmount;

  /**
   * 价外含税折扣
   */
  @TableField("outerDiscountWithTax")
  private String outerDiscountWithTax;

  /**
   * 价外不含税折扣
   */
  @TableField("outerDiscountWithoutTax")
  private String outerDiscountWithoutTax;

  /**
   * 价内含税折扣
   */
  @TableField("innerDiscountWithTax")
  private String innerDiscountWithTax;

  /**
   * 价内不含税折扣
   */
  @TableField("innerDiscountWithoutTax")
  private String innerDiscountWithoutTax;

  /**
   * 备注
   */
  private String remark;

  /**
   * 扩展字段1
   */
  private String ext1;

  /**
   * 扩展字段2
   */
  private String ext2;

  /**
   * 扩展字段3
   */
  private String ext3;

  /**
   * 扩展字段4
   */
  private String ext4;

  /**
   * 扩展字段5
   */
  private String ext5;

  /**
   * 订单状态
   */
  @TableField("orderStatus")
  private String orderStatus;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 组织树
   */
  private String orgTree;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 原订单号
   */
  @TableField("origOrderNo")
  private String origOrderNo;

  /**
   * 来源
   */
  private String source;

  /**
   * 订单类型
   */
  @TableField("orderType")
  private String orderType;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("bizOrderNo", bizOrderNo);
      map.put("orgCode", orgCode);
      map.put("pricingMethod", pricingMethod);
      map.put("amountWithTax", amountWithTax);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxAmount", taxAmount);
      map.put("outerDiscountWithTax", outerDiscountWithTax);
      map.put("outerDiscountWithoutTax", outerDiscountWithoutTax);
      map.put("innerDiscountWithTax", innerDiscountWithTax);
      map.put("innerDiscountWithoutTax", innerDiscountWithoutTax);
      map.put("remark", remark);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("ext4", ext4);
      map.put("ext5", ext5);
      map.put("orderStatus", orderStatus);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("origOrderNo", origOrderNo);
      map.put("source", source);
      map.put("orderType", orderType);

      return map;
  }

  public static OrderPool fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    OrderPool entity = new OrderPool();
    if(map.containsKey("bizOrderNo")) {
      Object obj = map.get("bizOrderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orgCode")) {
      Object obj = map.get("orgCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pricingMethod")) {
      Object obj = map.get("pricingMethod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPricingMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAmountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("outerDiscountWithTax")) {
      Object obj = map.get("outerDiscountWithTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOuterDiscountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("outerDiscountWithoutTax")) {
      Object obj = map.get("outerDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOuterDiscountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("innerDiscountWithTax")) {
      Object obj = map.get("innerDiscountWithTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInnerDiscountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("innerDiscountWithoutTax")) {
      Object obj = map.get("innerDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInnerDiscountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderStatus")) {
      Object obj = map.get("orderStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origOrderNo")) {
      Object obj = map.get("origOrderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrigOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderType")) {
      Object obj = map.get("orderType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderType((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("bizOrderNo")) {
      Object obj = map.get("bizOrderNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orgCode")) {
      Object obj = map.get("orgCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pricingMethod")) {
      Object obj = map.get("pricingMethod");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPricingMethod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAmountWithTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAmountWithoutTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("outerDiscountWithTax")) {
      Object obj = map.get("outerDiscountWithTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOuterDiscountWithTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("outerDiscountWithoutTax")) {
      Object obj = map.get("outerDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOuterDiscountWithoutTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("innerDiscountWithTax")) {
      Object obj = map.get("innerDiscountWithTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInnerDiscountWithTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("innerDiscountWithoutTax")) {
      Object obj = map.get("innerDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInnerDiscountWithoutTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderStatus")) {
      Object obj = map.get("orderStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("origOrderNo")) {
      Object obj = map.get("origOrderNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrigOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderType")) {
      Object obj = map.get("orderType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderType((String)obj);
        }
      } else {
      }
    }
  }
}
