package com.xforceplus.jcbabemax.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcbabemax.entity.BillIteam;
import com.xforceplus.jcbabemax.service.IBillIteamService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-03-25
 */
@RestController
public class BillIteamController {

  @Autowired
  private IBillIteamService billIteamServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billIteam ${table.comment}
   * @return
   */
  @GetMapping("/billiteams" )
  public XfR getBillIteams(XfPage page, BillIteam billIteam) {
    return XfR.ok(billIteamServiceImpl.page(page, Wrappers.query(billIteam)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billiteams/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billIteamServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billIteam ${table.comment}
   * @return XfR
   */
  @PostMapping("/billiteams")
  public XfR save(@RequestBody BillIteam billIteam) {
     return XfR.ok(billIteamServiceImpl.save(billIteam));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billIteam ${table.comment}
   * @return XfR
   */
  @PutMapping("/billiteams/{id}")
  public XfR putUpdate(@RequestBody BillIteam billIteam,@PathVariable Long id) {
      billIteam.setId(id);
      return XfR.ok(billIteamServiceImpl.updateById(billIteam));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billIteam ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billiteams/{id}")
  public XfR patchUpdate(@RequestBody BillIteam billIteam,@PathVariable Long id) {
      BillIteam upbillIteam = billIteamServiceImpl.getById(id);
      if(upbillIteam != null){
        upbillIteam = ObjectCopyUtils.copyProperties(billIteam,upbillIteam,true);
      }
      return XfR.ok(billIteamServiceImpl.updateById(upbillIteam));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billiteams/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billIteamServiceImpl.removeById(id));
  }

  @PostMapping("/billiteams/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_iteam");
     params.put("request", condition);

     return XfR.ok(billIteamServiceImpl.querys(params));
  }

}
