package com.xforceplus.jcbabemax.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcbabemax.entity.BillMain;
import com.xforceplus.jcbabemax.service.IBillMainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-03-17
 */
@RestController
public class BillMainController {

  @Autowired
  private IBillMainService billMainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billMain ${table.comment}
   * @return
   */
  @GetMapping("/billmains" )
  public XfR getBillMains(XfPage page, BillMain billMain) {
    return XfR.ok(billMainServiceImpl.page(page, Wrappers.query(billMain)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billmains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billMainServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billMain ${table.comment}
   * @return XfR
   */
  @PostMapping("/billmains")
  public XfR save(@RequestBody BillMain billMain) {
     return XfR.ok(billMainServiceImpl.save(billMain));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billMain ${table.comment}
   * @return XfR
   */
  @PutMapping("/billmains/{id}")
  public XfR putUpdate(@RequestBody BillMain billMain,@PathVariable Long id) {
      billMain.setId(id);
      return XfR.ok(billMainServiceImpl.updateById(billMain));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billMain ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billmains/{id}")
  public XfR patchUpdate(@RequestBody BillMain billMain,@PathVariable Long id) {
      BillMain upbillMain = billMainServiceImpl.getById(id);
      if(upbillMain != null){
        upbillMain = ObjectCopyUtils.copyProperties(billMain,upbillMain,true);
      }
      return XfR.ok(billMainServiceImpl.updateById(upbillMain));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billmains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billMainServiceImpl.removeById(id));
  }

  @PostMapping("/billmains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_main");
     params.put("request", condition);

     return XfR.ok(billMainServiceImpl.querys(params));
  }

}
