package com.xforceplus.jcbabemax.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcbabemax.entity.BillItem;
import com.xforceplus.jcbabemax.service.IBillItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-14
 */
@RestController
public class BillItemController {

  @Autowired
  private IBillItemService billItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billItem ${table.comment}
   * @return
   */
  @GetMapping("/billitems" )
  public XfR getBillItems(XfPage page, BillItem billItem) {
    return XfR.ok(billItemServiceImpl.page(page, Wrappers.query(billItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/billitems")
  public XfR save(@RequestBody BillItem billItem) {
     return XfR.ok(billItemServiceImpl.save(billItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/billitems/{id}")
  public XfR putUpdate(@RequestBody BillItem billItem,@PathVariable Long id) {
      billItem.setId(id);
      return XfR.ok(billItemServiceImpl.updateById(billItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billitems/{id}")
  public XfR patchUpdate(@RequestBody BillItem billItem,@PathVariable Long id) {
      BillItem upbillItem = billItemServiceImpl.getById(id);
      if(upbillItem != null){
        upbillItem = ObjectCopyUtils.copyProperties(billItem,upbillItem,true);
      }
      return XfR.ok(billItemServiceImpl.updateById(upbillItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billItemServiceImpl.removeById(id));
  }

  @PostMapping("/billitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_item");
     params.put("request", condition);

     return XfR.ok(billItemServiceImpl.querys(params));
  }

}
