package com.xforceplus.jcbabemax.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcbabemax.entity.OqsengineSdkOmAuditLog;
import com.xforceplus.jcbabemax.service.IOqsengineSdkOmAuditLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * OQSSDK运维工具操作记录前端控制器
 *
 * @author ultraman
 * @date 2025-10-14
 */
@RestController
public class OqsengineSdkOmAuditLogController {

  @Autowired
  private IOqsengineSdkOmAuditLogService oqsengineSdkOmAuditLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param oqsengineSdkOmAuditLog OQSSDK运维工具操作记录
   * @return
   */
  @GetMapping("/oqsenginesdkomauditlogs" )
  public XfR getOqsengineSdkOmAuditLogs(XfPage page, OqsengineSdkOmAuditLog oqsengineSdkOmAuditLog) {
    return XfR.ok(oqsengineSdkOmAuditLogServiceImpl.page(page, Wrappers.query(oqsengineSdkOmAuditLog)));
  }

  /**
   * 通过id查询OQSSDK运维工具操作记录
   * @param  id
   * @return XfR
   */
  @GetMapping("/oqsenginesdkomauditlogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(oqsengineSdkOmAuditLogServiceImpl.getById(id));
  }

  /**
   * 新增OQSSDK运维工具操作记录
   * @param oqsengineSdkOmAuditLog OQSSDK运维工具操作记录
   * @return XfR
   */
  @PostMapping("/oqsenginesdkomauditlogs")
  public XfR save(@RequestBody OqsengineSdkOmAuditLog oqsengineSdkOmAuditLog) {
     return XfR.ok(oqsengineSdkOmAuditLogServiceImpl.save(oqsengineSdkOmAuditLog));
  }

  /**
   * 修改-传入修改后的全部数据OQSSDK运维工具操作记录
   * @param oqsengineSdkOmAuditLog OQSSDK运维工具操作记录
   * @return XfR
   */
  @PutMapping("/oqsenginesdkomauditlogs/{id}")
  public XfR putUpdate(@RequestBody OqsengineSdkOmAuditLog oqsengineSdkOmAuditLog,@PathVariable Long id) {
      oqsengineSdkOmAuditLog.setId(id);
      return XfR.ok(oqsengineSdkOmAuditLogServiceImpl.updateById(oqsengineSdkOmAuditLog));
  }

  /**
   * 修改-传入修改的数据OQSSDK运维工具操作记录
   * @param oqsengineSdkOmAuditLog OQSSDK运维工具操作记录
   * @return XfR
   */
  @PatchMapping("/oqsenginesdkomauditlogs/{id}")
  public XfR patchUpdate(@RequestBody OqsengineSdkOmAuditLog oqsengineSdkOmAuditLog,@PathVariable Long id) {
      OqsengineSdkOmAuditLog upoqsengineSdkOmAuditLog = oqsengineSdkOmAuditLogServiceImpl.getById(id);
      if(upoqsengineSdkOmAuditLog != null){
        upoqsengineSdkOmAuditLog = ObjectCopyUtils.copyProperties(oqsengineSdkOmAuditLog,upoqsengineSdkOmAuditLog,true);
      }
      return XfR.ok(oqsengineSdkOmAuditLogServiceImpl.updateById(upoqsengineSdkOmAuditLog));
  }

  /**
   * 通过id删除OQSSDK运维工具操作记录
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/oqsenginesdkomauditlogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(oqsengineSdkOmAuditLogServiceImpl.removeById(id));
  }

  @PostMapping("/oqsenginesdkomauditlogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "oqsengine_sdk_om_audit_log");
     params.put("request", condition);

     return XfR.ok(oqsengineSdkOmAuditLogServiceImpl.querys(params));
  }

}
