package com.xforceplus.jcbabemax.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcbabemax.entity.SellerInvoiceMain;
import com.xforceplus.jcbabemax.service.ISellerInvoiceMainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-14
 */
@RestController
public class SellerInvoiceMainController {

  @Autowired
  private ISellerInvoiceMainService sellerInvoiceMainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param sellerInvoiceMain ${table.comment}
   * @return
   */
  @GetMapping("/sellerinvoicemains" )
  public XfR getSellerInvoiceMains(XfPage page, SellerInvoiceMain sellerInvoiceMain) {
    return XfR.ok(sellerInvoiceMainServiceImpl.page(page, Wrappers.query(sellerInvoiceMain)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/sellerinvoicemains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(sellerInvoiceMainServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param sellerInvoiceMain ${table.comment}
   * @return XfR
   */
  @PostMapping("/sellerinvoicemains")
  public XfR save(@RequestBody SellerInvoiceMain sellerInvoiceMain) {
     return XfR.ok(sellerInvoiceMainServiceImpl.save(sellerInvoiceMain));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param sellerInvoiceMain ${table.comment}
   * @return XfR
   */
  @PutMapping("/sellerinvoicemains/{id}")
  public XfR putUpdate(@RequestBody SellerInvoiceMain sellerInvoiceMain,@PathVariable Long id) {
      sellerInvoiceMain.setId(id);
      return XfR.ok(sellerInvoiceMainServiceImpl.updateById(sellerInvoiceMain));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param sellerInvoiceMain ${table.comment}
   * @return XfR
   */
  @PatchMapping("/sellerinvoicemains/{id}")
  public XfR patchUpdate(@RequestBody SellerInvoiceMain sellerInvoiceMain,@PathVariable Long id) {
      SellerInvoiceMain upsellerInvoiceMain = sellerInvoiceMainServiceImpl.getById(id);
      if(upsellerInvoiceMain != null){
        upsellerInvoiceMain = ObjectCopyUtils.copyProperties(sellerInvoiceMain,upsellerInvoiceMain,true);
      }
      return XfR.ok(sellerInvoiceMainServiceImpl.updateById(upsellerInvoiceMain));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/sellerinvoicemains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(sellerInvoiceMainServiceImpl.removeById(id));
  }

  @PostMapping("/sellerinvoicemains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "seller_invoice_main");
     params.put("request", condition);

     return XfR.ok(sellerInvoiceMainServiceImpl.querys(params));
  }

}
