package com.xforceplus.jcbaolong.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2021-05-18
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcbaolong.entity.OrderBillDetails;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-baolong")
public interface OrderBillDetailsFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/orderBillDetails/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param orderBillDetails ${table.comment}
   * @return R
   */
  @PostMapping("/orderBillDetails/add")
  public R save(@RequestBody OrderBillDetails orderBillDetails);

  /**
   * 修改${table.comment}
   * @param orderBillDetails ${table.comment}
   * @return R
   */
  @PostMapping("/orderBillDetails/update")
  public R updateById(@RequestBody OrderBillDetails orderBillDetails);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/orderBillDetails/del/{id}" )
  public R removeById(@PathVariable Long id);

}