package com.xforceplus.jcbaolong.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-04-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InterfaceRecord implements Serializable {

  private static final long serialVersionUID=1L;

  @TableField("recordeNo")
  private String recordeNo;

  @TableField("methodName")
  private String methodName;

  @TableField("interfaceDescribe")
  private String interfaceDescribe;

  @TableField("systemType")
  private String systemType;

  private String sender;

  private String receiver;

  @TableField("isSuccess")
  private Boolean isSuccess;

  @TableField("createTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField("requsetBody")
  private String requsetBody;

  @TableField("responseBody")
  private String responseBody;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  @TableField("interfaceType")
  private String interfaceType;

  @TableField("requestHead")
  private String requestHead;

  @TableField("dataSource")
  private String dataSource;

  private String url;

  @TableField("taxId")
  private String taxId;

  @TableField("billNo")
  private String billNo;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("recordeNo", recordeNo);
      map.put("methodName", methodName);
      map.put("interfaceDescribe", interfaceDescribe);
      map.put("systemType", systemType);
      map.put("sender", sender);
      map.put("receiver", receiver);
      map.put("isSuccess", isSuccess);
      map.put("createTime", BocpGenUtils.toTimestamp(createTime));
      map.put("requsetBody", requsetBody);
      map.put("responseBody", responseBody);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("interfaceType", interfaceType);
      map.put("requestHead", requestHead);
      map.put("dataSource", dataSource);
      map.put("url", url);
      map.put("taxId", taxId);
      map.put("billNo", billNo);
      return map;
  }

  public static InterfaceRecord fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    InterfaceRecord entity = new InterfaceRecord();
    if(map.containsKey("recordeNo")) {
      Object obj = map.get("recordeNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRecordeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("methodName")) {
      Object obj = map.get("methodName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMethodName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("interfaceDescribe")) {
      Object obj = map.get("interfaceDescribe");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInterfaceDescribe((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("systemType")) {
      Object obj = map.get("systemType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSystemType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sender")) {
      Object obj = map.get("sender");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSender((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiver")) {
      Object obj = map.get("receiver");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceiver((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isSuccess")) {
      Object obj = map.get("isSuccess");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsSuccess((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setIsSuccess(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("createTime")) {
      Object obj = map.get("createTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("requsetBody")) {
      Object obj = map.get("requsetBody");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRequsetBody((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("responseBody")) {
      Object obj = map.get("responseBody");
      if(obj != null) {
        if(obj instanceof String){
          entity.setResponseBody((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("interfaceType")) {
      Object obj = map.get("interfaceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInterfaceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("requestHead")) {
      Object obj = map.get("requestHead");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRequestHead((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataSource")) {
      Object obj = map.get("dataSource");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDataSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("url")) {
      Object obj = map.get("url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxId")) {
      Object obj = map.get("taxId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billNo")) {
      Object obj = map.get("billNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillNo((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
